/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.core;

import com.aizistral.nochatreports.core.ServerSafetyLevel;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_639;
import net.minecraft.class_642;

@Environment(value=EnvType.CLIENT)
public final class ServerSafetyState {
    private static ServerSafetyLevel current = ServerSafetyLevel.UNKNOWN;
    private static class_639 lastServerAddress = null;
    private static class_642 lastServerData = null;
    private static boolean allowUnsafeServer = false;
    private static boolean sessionRequestedKey = false;
    private static int reconnectCount = 0;

    public static void updateCurrent(ServerSafetyLevel level) {
        current = level;
    }

    public static ServerSafetyLevel getCurrent() {
        return current;
    }

    public static boolean allowsUnsafeServer() {
        return current != ServerSafetyLevel.SECURE ? allowUnsafeServer : false;
    }

    public static void setAllowsUnsafeServer(boolean allows) {
        allowUnsafeServer = allows;
    }

    public static void setSessionRequestedKey(boolean requested) {
        sessionRequestedKey = requested;
    }

    public static boolean sessionRequestedKey() {
        return current != ServerSafetyLevel.SECURE ? sessionRequestedKey : false;
    }

    public static boolean forceSignedMessages() {
        return ServerSafetyState.allowsUnsafeServer() && ServerSafetyState.sessionRequestedKey();
    }

    @Nullable
    public static class_639 getLastServerAddress() {
        return lastServerAddress;
    }

    @Nullable
    public static class_642 getLastServerData() {
        return lastServerData;
    }

    public static void setLastConnectedServer(@Nullable class_639 address, @Nullable class_642 data) {
        lastServerAddress = address;
        lastServerData = data;
    }

    public static int getReconnectCount() {
        return reconnectCount;
    }

    public static void setReconnectCount(int count) {
        reconnectCount = count;
    }

    public static void reset() {
        current = ServerSafetyLevel.UNKNOWN;
        sessionRequestedKey = false;
        allowUnsafeServer = false;
    }
}

