/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports;

import com.aizistral.nochatreports.NoChatReports;
import com.aizistral.nochatreports.config.NCRConfig;
import com.aizistral.nochatreports.core.ServerDataExtension;
import com.aizistral.nochatreports.core.ServerSafetyLevel;
import com.aizistral.nochatreports.core.ServerSafetyState;
import com.aizistral.nochatreports.gui.UnsafeServerScreen;
import com.aizistral.nochatreports.mixins.client.AccessorDisconnectedScreen;
import com.aizistral.nochatreports.network.ClientChannelHandler;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_5244;
import net.minecraft.class_634;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_7417;

@Environment(value=EnvType.CLIENT)
public final class NoChatReportsClient
implements ClientModInitializer {
    private static final List<String> KEY_DISCONNECT_REASONS = ImmutableList.of((Object)"multiplayer.disconnect.missing_public_key", (Object)"multiplayer.disconnect.invalid_public_key_signature", (Object)"multiplayer.disconnect.invalid_public_key");
    private static boolean screenOverride = false;

    public void onInitializeClient() {
        NoChatReports.LOGGER.info("Client initialization...");
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NoChatReports.CHANNEL, (ClientPlayNetworking.PlayChannelHandler)ClientChannelHandler.INSTANCE);
        ClientPlayConnectionEvents.JOIN.register(this::onPlayReady);
        ClientPlayConnectionEvents.DISCONNECT.register(this::onDisconnect);
        ScreenEvents.AFTER_INIT.register(this::onScreenInit);
    }

    private void onScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof AccessorDisconnectedScreen) {
            AccessorDisconnectedScreen dsc = (AccessorDisconnectedScreen)screen;
            if (screenOverride) {
                return;
            }
            screenOverride = true;
            class_7417 class_74172 = dsc.getReason().method_10851();
            if (class_74172 instanceof class_2588) {
                class_2588 contents = (class_2588)class_74172;
                if (ServerSafetyState.allowsUnsafeServer()) {
                    screen = new class_419((class_437)new class_500((class_437)new class_442()), class_5244.field_26625, dsc.getReason());
                    client.method_1507(screen);
                    screenOverride = false;
                    return;
                }
                if (KEY_DISCONNECT_REASONS.contains(contents.method_11022()) && ServerSafetyState.getLastServerAddress() != null) {
                    if (!NCRConfig.getServerWhitelist().isWhitelisted(ServerSafetyState.getLastServerAddress()) && !NCRConfig.getClient().whitelistAllServers()) {
                        client.method_1507((class_437)new UnsafeServerScreen());
                    } else if (ServerSafetyState.getReconnectCount() <= 0) {
                        ServerSafetyState.setAllowsUnsafeServer(true);
                        NoChatReportsClient.reconnectLastServer();
                    } else {
                        ServerSafetyState.setReconnectCount(0);
                    }
                }
            }
            screenOverride = false;
        }
    }

    private void onDisconnect(class_634 handler, class_310 client) {
        client.execute(ServerSafetyState::reset);
    }

    private void onPlayReady(class_634 handler, PacketSender sender, class_310 client) {
        client.execute(() -> {
            ServerSafetyState.setReconnectCount(0);
            if (!client.method_1542()) {
                boolean canSend = ClientPlayNetworking.canSend((class_2960)NoChatReports.CHANNEL);
                if (canSend) {
                    ServerSafetyState.updateCurrent(ServerSafetyLevel.SECURE);
                } else if (ServerSafetyState.forceSignedMessages()) {
                    ServerSafetyState.updateCurrent(ServerSafetyLevel.INSECURE);
                } else {
                    ServerDataExtension ext;
                    class_642 patt4361$temp = ServerSafetyState.getLastServerData();
                    if (patt4361$temp instanceof ServerDataExtension && (ext = (ServerDataExtension)patt4361$temp).preventsChatReports()) {
                        ServerSafetyState.updateCurrent(ServerSafetyLevel.SECURE);
                    } else {
                        ServerSafetyState.updateCurrent(ServerSafetyLevel.UNINTRUSIVE);
                    }
                }
            }
            if (NCRConfig.getClient().demandOnServer() && !ClientPlayNetworking.canSend((class_2960)NoChatReports.CHANNEL)) {
                handler.method_2872().method_10747((class_2561)class_2561.method_43471((String)"disconnect.nochatreports.client"));
            }
        });
    }

    public static void reconnectLastServer() {
        ServerSafetyState.setReconnectCount(ServerSafetyState.getReconnectCount() + 1);
        class_412.method_36877((class_437)new class_500((class_437)new class_442()), (class_310)class_310.method_1551(), (class_639)ServerSafetyState.getLastServerAddress(), (class_642)ServerSafetyState.getLastServerData());
    }
}

