/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Config
implements Serializable {
    private static final long serialVersionUID = 9132405079466337851L;
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Config INSTANCE = Config.loadOrCreate();
    public static final int VERSION = 1;
    public boolean hideSecondLayerUnderArmor = true;
    public boolean enableEffects = true;
    public boolean enableEnchantmentGlint = true;
    public int hudClockX = -111;
    public int hudClockY = -20;
    public int hudCompassX = 95;
    public int hudCompassY = -20;
    public HashMap<String, Boolean> enabledArmors = new HashMap();
    public int version;

    public Config() {
        this.enabledArmors.put("bone", true);
        this.enabledArmors.put("wither", true);
        this.enabledArmors.put("warrior", true);
        this.enabledArmors.put("heavy", true);
        this.enabledArmors.put("robe", true);
        this.enabledArmors.put("slime", true);
        this.enabledArmors.put("divine", true);
        this.enabledArmors.put("prismarine", true);
        this.enabledArmors.put("wooden", true);
        this.enabledArmors.put("steampunk", true);
        this.version = 0;
    }

    public static Config getInstance() {
        return INSTANCE;
    }

    public static File getConfigFile() {
        return new File("./config/immersive_armors.json");
    }

    public void save() {
        try (FileWriter writer = new FileWriter(Config.getConfigFile());){
            this.version = 1;
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Config loadOrCreate() {
        if (Config.getConfigFile().exists()) {
            Config config;
            FileReader reader = new FileReader(Config.getConfigFile());
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                Config config2 = (Config)gson.fromJson((Reader)reader, Config.class);
                if (config2.version != 1) {
                    config2 = new Config();
                }
                config2.save();
                config = config2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load Immersive Armors config! Default config is used for now. Delete the file to reset.");
                    e.printStackTrace();
                    return new Config();
                }
            }
            reader.close();
            return config;
        }
        Config config = new Config();
        config.save();
        return config;
    }
}

