/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.BetterCombatClient;
import net.bettercombat.client.BetterCombatKeybindings;
import net.bettercombat.client.MinecraftClientExtension;
import net.bettercombat.client.PlayerAttackAnimatable;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.config.ClientConfigWrapper;
import net.bettercombat.logic.AttackHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.mixin.client.MinecraftClientAccessor;
import net.bettercombat.network.Packets;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_542;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public abstract class MinecraftClientInject
implements MinecraftClientExtension {
    @Shadow
    public class_638 field_1687;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Final
    public class_327 field_1772;
    private boolean isHoldingAttackInput = false;
    private boolean isHarvesting = false;
    private boolean hasTargetsInRange = false;
    private String textToRender = null;
    private int textFade = 0;
    private static float ComboResetRate = 3.0f;
    private class_1799 upswingStack;
    private class_1799 lastAttacedWithItemStack;
    private int upswingTicks = 0;
    private int lastAttacked = 1000;
    private int comboReset = 0;
    private boolean ranTargetCheckCurrentTick = false;

    private class_310 thisClient() {
        return (class_310)this;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(class_542 args, CallbackInfo ci) {
        this.setupTextRenderer();
    }

    private void setupTextRenderer() {
        HudRenderCallback.EVENT.register((matrices, f) -> {
            if (this.textToRender != null && !this.textToRender.isEmpty()) {
                class_310 client = class_310.method_1551();
                class_327 textRenderer = client.field_1705.method_1756();
                int scaledWidth = client.method_22683().method_4486();
                int scaledHeight = client.method_22683().method_4502();
                int i = textRenderer.method_1727(this.textToRender);
                int j = (scaledWidth - i) / 2;
                int k = scaledHeight - 59 - 14;
                int l = 0;
                if (!client.field_1761.method_2908()) {
                    k += 14;
                }
                if ((l = (int)((float)this.textFade * 256.0f / 10.0f)) > 255) {
                    l = 255;
                }
                if (l > 0) {
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    Objects.requireNonNull(textRenderer);
                    class_329.method_25294((class_4587)matrices, (int)(j - 2), (int)(k - 2), (int)(j + i + 2), (int)(k + 9 + 2), (int)client.field_1690.method_19344(0));
                    textRenderer.method_1720(matrices, this.textToRender, (float)j, (float)k, 0xFFFFFF + (l << 24));
                    RenderSystem.disableBlend();
                }
            }
            if (this.textFade <= 0) {
                this.textToRender = null;
            }
        });
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doAttack(CallbackInfoReturnable<Boolean> info) {
        class_310 client = this.thisClient();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(client.field_1724.method_6047());
        if (attributes != null) {
            if (this.isTargetingMineableBlock() || this.isHarvesting) {
                this.isHarvesting = true;
                return;
            }
            this.startUpswing(attributes);
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_handleBlockBreaking(boolean bl, CallbackInfo ci) {
        class_310 client = this.thisClient();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(client.field_1724.method_6047());
        if (attributes != null) {
            boolean isPressed = client.field_1690.field_1886.method_1434();
            if (isPressed && !this.isHoldingAttackInput) {
                if (this.isTargetingMineableBlock() || this.isHarvesting) {
                    this.isHarvesting = true;
                    return;
                }
                ci.cancel();
            }
            if (BetterCombatClient.config.isHoldToAttackEnabled && isPressed) {
                this.isHoldingAttackInput = true;
                this.startUpswing(attributes);
                ci.cancel();
            } else {
                this.isHarvesting = false;
                this.isHoldingAttackInput = false;
            }
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doItemUse(CallbackInfo ci) {
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        double upswingRate = hand.upswingRate();
        if (this.upswingTicks > 0 || (double)this.field_1724.method_7261(0.0f) < 1.0 - upswingRate) {
            ci.cancel();
        }
    }

    private boolean isTargetingMineableBlock() {
        if (!BetterCombatClient.config.isMiningWithWeaponsEnabled) {
            return false;
        }
        class_310 client = this.thisClient();
        class_239 crosshairTarget = client.field_1765;
        if (crosshairTarget != null && crosshairTarget.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)crosshairTarget;
            class_2338 pos = blockHitResult.method_17777();
            class_2680 clicked = this.field_1687.method_8320(pos);
            if (BetterCombatClient.config.isSwingThruGrassEnabled) {
                if (!clicked.method_26220((class_1922)this.field_1687, pos).method_1110() || clicked.method_26214((class_1922)this.field_1687, pos) != 0.0f) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void startUpswing(WeaponAttributes attributes) {
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        double upswingRate = hand.upswingRate();
        if (this.upswingTicks > 0 || this.field_1724.method_6115() || (double)this.field_1724.method_7261(0.0f) < 1.0 - upswingRate) {
            return;
        }
        this.field_1724.method_6075();
        this.lastAttacked = 0;
        this.upswingStack = this.field_1724.method_6047();
        float attackCooldownTicks = this.field_1724.method_7279();
        this.comboReset = Math.round(attackCooldownTicks * ComboResetRate);
        this.upswingTicks = (int)Math.round((double)attackCooldownTicks * upswingRate);
        String animationName = hand.attack().animation();
        boolean isOffHand = hand.isOffHand();
        ((PlayerAttackAnimatable)this.field_1724).playAttackAnimation(animationName, isOffHand, attackCooldownTicks);
        ClientPlayNetworking.send((class_2960)Packets.AttackAnimation.ID, (class_2540)new Packets.AttackAnimation(this.field_1724.method_5628(), isOffHand, animationName, attackCooldownTicks).write());
    }

    private void feintIfNeeded() {
        if (this.upswingTicks > 0 && (BetterCombatKeybindings.feintKeyBinding.method_1434() || !MinecraftClientInject.areItemStackEqual(this.field_1724.method_6047(), this.upswingStack))) {
            ((PlayerAttackAnimatable)this.field_1724).stopAttackAnimation();
            ClientPlayNetworking.send((class_2960)Packets.AttackAnimation.ID, (class_2540)Packets.AttackAnimation.stop(this.field_1724.method_5628()).write());
            this.upswingTicks = 0;
            this.upswingStack = null;
        }
    }

    private void attackFromUpswingIfNeeded() {
        if (this.upswingTicks > 0) {
            --this.upswingTicks;
            if (this.upswingTicks == 0) {
                this.performAttack();
                this.upswingStack = null;
            }
        }
    }

    private void resetComboIfNeeded() {
        if (this.lastAttacked > this.comboReset && this.getComboCount() > 0) {
            this.setComboCount(0);
        }
        if (!PlayerAttackHelper.shouldAttackWithOffHand((class_1657)this.field_1724, this.getComboCount()) && (this.field_1724.method_6047() == null || this.lastAttacedWithItemStack != null && !this.lastAttacedWithItemStack.method_7909().equals(this.field_1724.method_6047().method_7909()))) {
            this.setComboCount(0);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void pre_Tick(CallbackInfo ci) {
        if (this.field_1724 == null) {
            return;
        }
        this.ranTargetCheckCurrentTick = false;
        ++this.lastAttacked;
        this.feintIfNeeded();
        this.attackFromUpswingIfNeeded();
        this.resetComboIfNeeded();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void post_Tick(CallbackInfo ci) {
        if (this.field_1724 == null) {
            return;
        }
        if (BetterCombatClient.config.isHighlightCrosshairEnabled && !this.ranTargetCheckCurrentTick) {
            class_310 client = this.thisClient();
            AttackHand hand = PlayerAttackHelper.getCurrentAttack((class_1657)this.field_1724, this.getComboCount());
            WeaponAttributes attributes = WeaponRegistry.getAttributes(client.field_1724.method_6047());
            List<class_1297> targets = List.of();
            if (attributes != null) {
                targets = TargetFinder.findAttackTargets((class_1657)this.field_1724, this.getCursorTarget(), hand.attack(), attributes.attackRange());
            }
            this.updateTargetsInRage(targets);
        }
        if (BetterCombatKeybindings.toggleMineKeyBinding.method_1436()) {
            BetterCombatClient.config.isMiningWithWeaponsEnabled = !BetterCombatClient.config.isMiningWithWeaponsEnabled;
            AutoConfig.getConfigHolder(ClientConfigWrapper.class).save();
            this.textToRender = class_1074.method_4662((String)"text.autoconfig.bettercombat.option.client.isMiningWithWeaponsEnabled", (Object[])new Object[0]) + ": " + class_1074.method_4662((String)(BetterCombatClient.config.isMiningWithWeaponsEnabled ? "gui.yes" : "gui.no"), (Object[])new Object[0]);
            this.textFade = 40;
        }
        if (this.textFade > 0) {
            --this.textFade;
        }
    }

    private void performAttack() {
        class_310 client = this.thisClient();
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        WeaponAttributes.Attack attack = hand.attack();
        double upswingRate = hand.upswingRate();
        if ((double)client.field_1724.method_7261(0.0f) < 1.0 - upswingRate) {
            return;
        }
        List<class_1297> targets = TargetFinder.findAttackTargets((class_1657)this.field_1724, this.getCursorTarget(), attack, hand.attributes().attackRange());
        this.updateTargetsInRage(targets);
        ClientPlayNetworking.send((class_2960)Packets.C2S_AttackRequest.ID, (class_2540)new Packets.C2S_AttackRequest(this.getComboCount(), this.field_1724.method_5715(), targets).write());
        client.field_1724.method_7350();
        ((MinecraftClientAccessor)client).setAttackCooldown(10);
        this.setComboCount(this.getComboCount() + 1);
        if (!hand.isOffHand()) {
            this.lastAttacedWithItemStack = hand.itemStack();
        }
    }

    private AttackHand getCurrentHand() {
        return PlayerAttackHelper.getCurrentAttack((class_1657)this.field_1724, this.getComboCount());
    }

    private void updateTargetsInRage(List<class_1297> targets) {
        this.hasTargetsInRange = targets.size() > 0;
        this.ranTargetCheckCurrentTick = true;
    }

    private void setComboCount(int comboCount) {
        ((PlayerAttackProperties)this.field_1724).setComboCount(comboCount);
    }

    @Override
    public int getComboCount() {
        return ((PlayerAttackProperties)this.field_1724).getComboCount();
    }

    @Override
    public boolean hasTargetsInRange() {
        return this.hasTargetsInRange;
    }

    private static boolean areItemStackEqual(class_1799 left, class_1799 right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return class_1799.method_7973((class_1799)left, (class_1799)right);
    }
}

