/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.MinecraftClientExtension;
import net.bettercombat.client.collision.OrientedBoundingBox;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.logic.AttackHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.mixin.client.MinecraftClientAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_863;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_863.class})
public class ColliderDebugRenderer {
    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void renderColliderDebug(class_4587 matrices, class_4597.class_4598 vertexConsumers, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (!((MinecraftClientAccessor)client).getEntityRenderDispatcher().method_3958()) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332()) {
            return;
        }
        if (client.field_1724.method_6047() == null) {
            return;
        }
        MinecraftClientExtension extendedClient = (MinecraftClientExtension)client;
        int comboCount = extendedClient.getComboCount();
        AttackHand hand = PlayerAttackHelper.getCurrentAttack((class_1657)client.field_1724, comboCount);
        if (hand == null) {
            return;
        }
        WeaponAttributes attributes = hand.attributes();
        if (attributes == null) {
            return;
        }
        class_1297 cursorTarget = extendedClient.getCursorTarget();
        TargetFinder.TargetResult target = TargetFinder.findAttackTargetResult((class_1657)player, cursorTarget, hand.attack(), attributes.attackRange());
        boolean collides = target.entities.size() > 0;
        class_243 cameraOffset = camera.method_19326().method_22882();
        OrientedBoundingBox obb = target.obb.copy().offset(cameraOffset).updateVertex();
        List<OrientedBoundingBox> collidingObbs = target.entities.stream().map(entity -> new OrientedBoundingBox(entity.method_5829()).offset(cameraOffset).scale(0.95).updateVertex()).collect(Collectors.toList());
        this.drawOutline(obb, collidingObbs, collides);
    }

    private void drawOutline(OrientedBoundingBox obb, List<OrientedBoundingBox> otherObbs, boolean collides) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        if (collides) {
            this.outlineOBB(obb, bufferBuilder, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
        } else {
            this.outlineOBB(obb, bufferBuilder, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.5f);
        }
        this.look(obb, bufferBuilder, 0.5f);
        for (OrientedBoundingBox otherObb : otherObbs) {
            this.outlineOBB(otherObb, bufferBuilder, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.5f);
        }
        tessellator.method_1350();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
    }

    private void outlineOBB(OrientedBoundingBox box, class_287 buffer, float red1, float green1, float blue1, float red2, float green2, float blue2, float alpha) {
        buffer.method_22912(box.vertex1.field_1352, box.vertex1.field_1351, box.vertex1.field_1350).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22912(box.vertex1.field_1352, box.vertex1.field_1351, box.vertex1.field_1350).method_22915(red1, green1, blue1, alpha).method_1344();
        buffer.method_22912(box.vertex2.field_1352, box.vertex2.field_1351, box.vertex2.field_1350).method_22915(red1, green1, blue1, alpha).method_1344();
        buffer.method_22912(box.vertex3.field_1352, box.vertex3.field_1351, box.vertex3.field_1350).method_22915(red1, green1, blue1, alpha).method_1344();
        buffer.method_22912(box.vertex4.field_1352, box.vertex4.field_1351, box.vertex4.field_1350).method_22915(red1, green1, blue1, alpha).method_1344();
        buffer.method_22912(box.vertex1.field_1352, box.vertex1.field_1351, box.vertex1.field_1350).method_22915(red1, green1, blue1, alpha).method_1344();
        buffer.method_22912(box.vertex5.field_1352, box.vertex5.field_1351, box.vertex5.field_1350).method_22915(red2, green2, blue2, alpha).method_1344();
        buffer.method_22912(box.vertex6.field_1352, box.vertex6.field_1351, box.vertex6.field_1350).method_22915(red2, green2, blue2, alpha).method_1344();
        buffer.method_22912(box.vertex2.field_1352, box.vertex2.field_1351, box.vertex2.field_1350).method_22915(red1, green1, blue1, alpha).method_1344();
        buffer.method_22912(box.vertex6.field_1352, box.vertex6.field_1351, box.vertex6.field_1350).method_22915(red2, green2, blue2, alpha).method_1344();
        buffer.method_22912(box.vertex7.field_1352, box.vertex7.field_1351, box.vertex7.field_1350).method_22915(red2, green2, blue2, alpha).method_1344();
        buffer.method_22912(box.vertex3.field_1352, box.vertex3.field_1351, box.vertex3.field_1350).method_22915(red1, green1, blue1, alpha).method_1344();
        buffer.method_22912(box.vertex7.field_1352, box.vertex7.field_1351, box.vertex7.field_1350).method_22915(red2, green2, blue2, alpha).method_1344();
        buffer.method_22912(box.vertex8.field_1352, box.vertex8.field_1351, box.vertex8.field_1350).method_22915(red2, green2, blue2, alpha).method_1344();
        buffer.method_22912(box.vertex4.field_1352, box.vertex4.field_1351, box.vertex4.field_1350).method_22915(red1, green1, blue1, alpha).method_1344();
        buffer.method_22912(box.vertex8.field_1352, box.vertex8.field_1351, box.vertex8.field_1350).method_22915(red2, green2, blue2, alpha).method_1344();
        buffer.method_22912(box.vertex5.field_1352, box.vertex5.field_1351, box.vertex5.field_1350).method_22915(red2, green2, blue2, alpha).method_1344();
        buffer.method_22912(box.vertex5.field_1352, box.vertex5.field_1351, box.vertex5.field_1350).method_1336(0, 0, 0, 0).method_1344();
        buffer.method_22912(box.center.field_1352, box.center.field_1351, box.center.field_1350).method_1336(0, 0, 0, 0).method_1344();
    }

    private void look(OrientedBoundingBox box, class_287 buffer, float alpha) {
        buffer.method_22912(box.center.field_1352, box.center.field_1351, box.center.field_1350).method_22915(0.0f, 0.0f, 0.0f, alpha).method_1344();
        buffer.method_22912(box.center.field_1352, box.center.field_1351, box.center.field_1350).method_22915(1.0f, 0.0f, 0.0f, alpha).method_1344();
        buffer.method_22912(box.axisZ.field_1352, box.axisZ.field_1351, box.axisZ.field_1350).method_22915(1.0f, 0.0f, 0.0f, alpha).method_1344();
        buffer.method_22912(box.center.field_1352, box.center.field_1351, box.center.field_1350).method_22915(1.0f, 0.0f, 0.0f, alpha).method_1344();
        buffer.method_22912(box.center.field_1352, box.center.field_1351, box.center.field_1350).method_22915(0.0f, 1.0f, 0.0f, alpha).method_1344();
        buffer.method_22912(box.axisY.field_1352, box.axisY.field_1351, box.axisY.field_1350).method_22915(0.0f, 1.0f, 0.0f, alpha).method_1344();
        buffer.method_22912(box.center.field_1352, box.center.field_1351, box.center.field_1350).method_22915(0.0f, 1.0f, 0.0f, alpha).method_1344();
        buffer.method_22912(box.center.field_1352, box.center.field_1351, box.center.field_1350).method_22915(0.0f, 0.0f, 1.0f, alpha).method_1344();
        buffer.method_22912(box.axisX.field_1352, box.axisX.field_1351, box.axisX.field_1350).method_22915(0.0f, 0.0f, 1.0f, alpha).method_1344();
        buffer.method_22912(box.center.field_1352, box.center.field_1351, box.center.field_1350).method_22915(0.0f, 0.0f, 1.0f, alpha).method_1344();
        buffer.method_22912(box.center.field_1352, box.center.field_1351, box.center.field_1350).method_22915(0.0f, 0.0f, 0.0f, alpha).method_1344();
    }

    public void printDebug(OrientedBoundingBox obb) {
        class_243 extent_x = obb.axisX.method_1021(obb.extent.field_1352);
        class_243 extent_y = obb.axisY.method_1021(obb.extent.field_1351);
        class_243 extent_z = obb.axisZ.method_1021(obb.extent.field_1350);
        System.out.println("Center: " + this.vec3Short(obb.center) + " Extent: " + this.vec3Short(obb.extent));
        System.out.println("scaledAxisX: " + this.vec3Short(obb.scaledAxisX) + "scaledAxisY: " + this.vec3Short(obb.scaledAxisY) + "scaledAxisZ: " + this.vec3Short(obb.scaledAxisZ));
        System.out.println("1:" + this.vec3Short(obb.vertex1) + " 2:" + this.vec3Short(obb.vertex2) + " 3:" + this.vec3Short(obb.vertex3) + " 4:" + this.vec3Short(obb.vertex4));
        System.out.println("5:" + this.vec3Short(obb.vertex5) + " 6:" + this.vec3Short(obb.vertex6) + " 7:" + this.vec3Short(obb.vertex7) + " 8:" + this.vec3Short(obb.vertex8));
    }

    private String vec3Short(class_243 vec) {
        return "{" + String.format("%.3f", vec.field_1352) + ", " + String.format("%.3f", vec.field_1351) + ", " + String.format("%.3f", vec.field_1350) + "}";
    }

    private class_243[] getVertices(class_238 box) {
        return new class_243[]{new class_243(box.field_1323, box.field_1322, box.field_1321), new class_243(box.field_1320, box.field_1322, box.field_1321), new class_243(box.field_1323, box.field_1325, box.field_1321), new class_243(box.field_1323, box.field_1322, box.field_1324), new class_243(box.field_1320, box.field_1325, box.field_1321), new class_243(box.field_1323, box.field_1325, box.field_1324), new class_243(box.field_1320, box.field_1322, box.field_1324), new class_243(box.field_1320, box.field_1325, box.field_1324)};
    }
}

