/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import java.util.Optional;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.AnimationRegistry;
import net.bettercombat.client.BetterCombatClient;
import net.bettercombat.client.PlayerAttackAnimatable;
import net.bettercombat.client.animation.AdjustmentModifier;
import net.bettercombat.client.animation.AttackAnimationSubStack;
import net.bettercombat.client.animation.CustomAnimationPlayer;
import net.bettercombat.client.animation.FirstPersonRenderHelper;
import net.bettercombat.client.animation.PoseSubStack;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.mixin.LivingEntityAccessor;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4050;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_7428;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_742.class})
public abstract class AbstractClientPlayerEntityMixin
extends class_1657
implements PlayerAttackAnimatable {
    private final PoseSubStack mainHandPose = new PoseSubStack(this.createPoseAdjustment(), true);
    private final PoseSubStack offHandPose = new PoseSubStack(null, false);
    private final AttackAnimationSubStack attackAnimation = new AttackAnimationSubStack(this.createAttackAdjustment());

    public AbstractClientPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile, @Nullable class_7428 publicKey) {
        super(world, pos, yaw, gameProfile, publicKey);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(class_638 world, GameProfile profile, class_7428 publicKey, CallbackInfo ci) {
        AnimationStack stack = ((IAnimatedPlayer)this).getAnimationStack();
        stack.addAnimLayer(1, (IAnimation)this.offHandPose.base);
        stack.addAnimLayer(2, (IAnimation)this.mainHandPose.base);
        stack.addAnimLayer(2000, (IAnimation)this.attackAnimation.base);
        this.mainHandPose.configure = this::updateAnimationByCurrentActivity;
        this.offHandPose.configure = this::updateAnimationByCurrentActivity;
    }

    @Override
    public void updateAnimationsOnTick() {
        WeaponAttributes offHandAttributes;
        AbstractClientPlayerEntityMixin instance = this;
        class_1657 player = instance;
        boolean isLeftHanded = this.isLeftHanded();
        if (player.field_6252 || player.method_6115()) {
            this.offHandPose.setPose(null, isLeftHanded);
            this.mainHandPose.setPose(null, isLeftHanded);
            return;
        }
        if (this.getCurrentAnimation().isPresent() && this.getCurrentAnimation().get().isActive()) {
            ((LivingEntityAccessor)player).invokeTurnHead(player.method_5791(), 0.0f);
        }
        KeyframeAnimation newMainHandPose = null;
        WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes(player.method_6047());
        if (mainHandAttributes != null && mainHandAttributes.pose() != null) {
            newMainHandPose = AnimationRegistry.animations.get(mainHandAttributes.pose());
        }
        this.mainHandPose.setPose(newMainHandPose, isLeftHanded);
        KeyframeAnimation newOffHandPose = null;
        if (PlayerAttackHelper.isDualWielding(player) && (offHandAttributes = WeaponRegistry.getAttributes(player.method_6079())) != null && offHandAttributes.offHandPose() != null) {
            newOffHandPose = AnimationRegistry.animations.get(offHandAttributes.offHandPose());
        }
        this.offHandPose.setPose(newOffHandPose, isLeftHanded);
    }

    @Override
    public void playAttackAnimation(String name, boolean isOffHand, float length) {
        try {
            KeyframeAnimation animation = AnimationRegistry.animations.get(name);
            KeyframeAnimation.AnimationBuilder copy = animation.mutableCopy();
            this.updateAnimationByCurrentActivity(copy);
            copy.torso.fullyEnablePart(true);
            copy.head.pitch.setEnabled(false);
            float speed = (float)animation.endTick / length;
            boolean mirror = isOffHand;
            if (this.isLeftHanded()) {
                mirror = !mirror;
            }
            int fadeIn = copy.beginTick;
            this.attackAnimation.speed.speed = speed;
            this.attackAnimation.mirror.setEnabled(mirror);
            if (BetterCombatClient.config.isSmoothAnimationTransitionEnabled) {
                this.attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)fadeIn, (Ease)Ease.INOUTSINE), (IAnimation)new CustomAnimationPlayer(copy.build(), 0));
            } else {
                this.attackAnimation.base.setAnimation((IAnimation)new CustomAnimationPlayer(copy.build(), 0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AdjustmentModifier createAttackAdjustment() {
        AbstractClientPlayerEntityMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (FirstPersonRenderHelper.isRenderingFirstPersonPlayerModel) {
                float pitch = player.method_36455();
                pitch = (float)Math.toRadians(pitch);
                switch (partName) {
                    case "rightArm": 
                    case "leftArm": {
                        rotationX = pitch;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            } else {
                float pitch = player.method_36455() / 2.0f;
                pitch = (float)Math.toRadians(pitch);
                switch (partName) {
                    case "body": {
                        rotationX = -1.0f * pitch;
                        break;
                    }
                    case "rightArm": 
                    case "leftArm": {
                        rotationX = pitch;
                        break;
                    }
                    case "rightLeg": 
                    case "leftLeg": {
                        rotationX = -1.0f * pitch;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private AdjustmentModifier createPoseAdjustment() {
        AbstractClientPlayerEntityMixin player = this;
        return new AdjustmentModifier(partName -> {
            float rotationX = 0.0f;
            float rotationY = 0.0f;
            float rotationZ = 0.0f;
            float offsetX = 0.0f;
            float offsetY = 0.0f;
            float offsetZ = 0.0f;
            if (!FirstPersonRenderHelper.isRenderingFirstPersonPlayerModel) {
                switch (partName) {
                    case "rightArm": 
                    case "leftArm": {
                        if (!player.method_5715()) break;
                        offsetY += 4.0f;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
        });
    }

    private void updateAnimationByCurrentActivity(KeyframeAnimation.AnimationBuilder animation) {
        class_4050 pose = this.method_18376();
        switch (pose) {
            case field_18076: {
                break;
            }
            case field_18077: {
                break;
            }
            case field_18078: {
                break;
            }
            case field_18079: {
                AbstractClientPlayerEntityMixin.configurBodyPart(animation.rightLeg, false, false);
                AbstractClientPlayerEntityMixin.configurBodyPart(animation.leftLeg, false, false);
                break;
            }
            case field_18080: {
                break;
            }
            case field_18081: {
                break;
            }
            case field_30095: {
                break;
            }
        }
        if (this.isMounting()) {
            AbstractClientPlayerEntityMixin.configurBodyPart(animation.rightLeg, false, false);
            AbstractClientPlayerEntityMixin.configurBodyPart(animation.leftLeg, false, false);
        }
    }

    private static void configurBodyPart(KeyframeAnimation.StateCollection bodyPart, boolean isRotationEnabled, boolean isOffsetEnabled) {
        bodyPart.pitch.setEnabled(isRotationEnabled);
        bodyPart.roll.setEnabled(isRotationEnabled);
        bodyPart.yaw.setEnabled(isRotationEnabled);
        bodyPart.x.setEnabled(isOffsetEnabled);
        bodyPart.y.setEnabled(isOffsetEnabled);
        bodyPart.z.setEnabled(isOffsetEnabled);
    }

    @Override
    public void stopAttackAnimation() {
        IAnimation currentAnimation = this.attackAnimation.base.getAnimation();
        if (currentAnimation != null && currentAnimation instanceof KeyframeAnimationPlayer) {
            if (BetterCombatClient.config.isSmoothAnimationTransitionEnabled) {
                this.attackAnimation.base.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTSINE), null);
            } else {
                ((KeyframeAnimationPlayer)currentAnimation).stop();
            }
        }
    }

    private boolean isMounting() {
        return this.method_5854() != null;
    }

    public boolean isLeftHanded() {
        return this.method_6068() == class_1306.field_6182;
    }

    @Override
    public Optional<IAnimation> getCurrentAnimation() {
        return Optional.ofNullable(this.attackAnimation.base.getAnimation());
    }
}

