/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.PlayerAttackAnimatable;
import net.bettercombat.logic.AttackHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.mixin.PlayerEntityAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityInject
implements PlayerAttackProperties {
    private int comboCount = 0;
    private Multimap<class_1320, class_1322> dualWieldingAttributeMap;
    private static UUID dualWieldingSpeedModifierId = UUID.fromString("6b364332-0dc4-11ed-861d-0242ac120002");

    @Override
    public int getComboCount() {
        return this.comboCount;
    }

    @Override
    public void setComboCount(int comboCount) {
        this.comboCount = comboCount;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void post_Tick(CallbackInfo ci) {
        PlayerEntityInject instance = this;
        if (((class_1657)instance).field_6002.method_8608()) {
            ((PlayerAttackAnimatable)((Object)this)).updateAnimationsOnTick();
        }
        this.updateDualWieldingSpeedBoost();
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE"), ordinal=3)
    private boolean disableSweeping(boolean value) {
        if (BetterCombat.config.allow_sweeping) {
            return value;
        }
        class_1657 player = (class_1657)this;
        AttackHand currentHand = PlayerAttackHelper.getCurrentAttack(player, this.comboCount);
        if (currentHand != null) {
            return false;
        }
        return value;
    }

    @Inject(method={"getEquippedStack"}, at={@At(value="HEAD")}, cancellable=true)
    public void getEquippedStack_Pre(class_1304 slot, CallbackInfoReturnable<class_1799> cir) {
        boolean mainHandHasTwoHanded = false;
        class_1799 mainHandStack = ((PlayerEntityAccessor)((Object)this)).getInventory().method_7391();
        WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes(mainHandStack);
        if (mainHandAttributes != null && mainHandAttributes.isTwoHanded()) {
            mainHandHasTwoHanded = true;
        }
        boolean offHandHasTwoHanded = false;
        class_1799 offHandStack = (class_1799)((PlayerEntityAccessor)((Object)this)).getInventory().field_7544.get(0);
        WeaponAttributes offHandAttributes = WeaponRegistry.getAttributes(offHandStack);
        if (offHandAttributes != null && offHandAttributes.isTwoHanded()) {
            offHandHasTwoHanded = true;
        }
        if (slot == class_1304.field_6171 && (mainHandHasTwoHanded || offHandHasTwoHanded)) {
            cir.setReturnValue((Object)class_1799.field_8037);
            cir.cancel();
            return;
        }
    }

    private void updateDualWieldingSpeedBoost() {
        boolean currentState;
        class_1657 player = (class_1657)this;
        boolean newState = PlayerAttackHelper.isDualWielding(player);
        boolean bl = currentState = this.dualWieldingAttributeMap != null;
        if (newState != currentState) {
            if (newState) {
                this.dualWieldingAttributeMap = HashMultimap.create();
                double multiplier = BetterCombat.config.dual_wielding_attack_speed_multiplier - 1.0f;
                this.dualWieldingAttributeMap.put((Object)class_5134.field_23723, (Object)new class_1322(dualWieldingSpeedModifierId, "Dual wielding attack speed boost", multiplier, class_1322.class_1323.field_6330));
                player.method_6127().method_26854(this.dualWieldingAttributeMap);
            } else if (this.dualWieldingAttributeMap != null) {
                player.method_6127().method_26847(this.dualWieldingAttributeMap);
                this.dualWieldingAttributeMap = null;
            }
        }
    }

    @ModifyArg(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getStackInHand(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;"), index=0)
    public class_1268 getHand(class_1268 hand) {
        class_1657 player = (class_1657)this;
        AttackHand currentHand = PlayerAttackHelper.getCurrentAttack(player, this.comboCount);
        if (currentHand != null) {
            return currentHand.isOffHand() ? class_1268.field_5810 : class_1268.field_5808;
        }
        return class_1268.field_5808;
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getMainHandStack()Lnet/minecraft/item/ItemStack;"))
    public class_1799 getMainHandStack_Redirect(class_1657 instance) {
        if (this.comboCount < 0) {
            return instance.method_6047();
        }
        AttackHand hand = PlayerAttackHelper.getCurrentAttack(instance, this.comboCount);
        if (hand == null) {
            boolean isOffHand = PlayerAttackHelper.shouldAttackWithOffHand(instance, this.comboCount);
            if (isOffHand) {
                return class_1799.field_8037;
            }
            return instance.method_6047();
        }
        return hand.itemStack();
    }

    @Redirect(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;setStackInHand(Lnet/minecraft/util/Hand;Lnet/minecraft/item/ItemStack;)V"))
    public void setStackInHand_Redirect(class_1657 instance, class_1268 handArg, class_1799 itemStack) {
        AttackHand hand;
        if (this.comboCount < 0) {
            instance.method_6122(handArg, itemStack);
        }
        if ((hand = PlayerAttackHelper.getCurrentAttack(instance, this.comboCount)) == null) {
            instance.method_6122(handArg, itemStack);
            return;
        }
        class_1268 redirectedHand = hand.isOffHand() ? class_1268.field_5810 : class_1268.field_5808;
        instance.method_6122(redirectedHand, itemStack);
    }
}

