/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import java.util.Arrays;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.logic.AttackHand;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class PlayerAttackHelper {
    public static float getDualWieldingAttackDamageMultiplier(class_1657 player, AttackHand hand) {
        return PlayerAttackHelper.isDualWielding(player) ? (hand.isOffHand() ? BetterCombat.config.dual_wielding_off_hand_damage_multiplier : BetterCombat.config.dual_wielding_main_hand_damage_multiplier) : 1.0f;
    }

    public static boolean shouldAttackWithOffHand(class_1657 player, int comboCount) {
        return PlayerAttackHelper.isDualWielding(player) && comboCount % 2 == 1;
    }

    public static boolean isDualWielding(class_1657 player) {
        WeaponAttributes mainAttributes = WeaponRegistry.getAttributes(player.method_6047());
        WeaponAttributes offAttributes = WeaponRegistry.getAttributes(player.method_6079());
        return mainAttributes != null && !mainAttributes.isTwoHanded() && offAttributes != null && !offAttributes.isTwoHanded();
    }

    public static AttackHand getCurrentAttack(class_1657 player, int comboCount) {
        if (PlayerAttackHelper.isDualWielding(player)) {
            boolean isOffHand = PlayerAttackHelper.shouldAttackWithOffHand(player, comboCount);
            class_1799 itemStack = isOffHand ? player.method_6079() : player.method_6047();
            WeaponAttributes attributes = WeaponRegistry.getAttributes(itemStack);
            int handSpecificComboCount = (isOffHand && comboCount > 0 ? comboCount - 1 : comboCount) / 2;
            WeaponAttributes.Attack attack = PlayerAttackHelper.selectAttack(handSpecificComboCount, attributes, player, isOffHand);
            return new AttackHand(attack, isOffHand, attributes, itemStack);
        }
        class_1799 itemStack = player.method_6047();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(itemStack);
        if (attributes != null) {
            WeaponAttributes.Attack attack = PlayerAttackHelper.selectAttack(comboCount, attributes, player, false);
            return new AttackHand(attack, false, attributes, itemStack);
        }
        return null;
    }

    private static WeaponAttributes.Attack selectAttack(int comboCount, WeaponAttributes attributes, class_1657 player, boolean isOffHandAttack) {
        WeaponAttributes.Attack[] attacks = attributes.attacks();
        attacks = (WeaponAttributes.Attack[])Arrays.stream(attacks).filter(attack -> attack.conditions() == null || attack.conditions().length == 0 || PlayerAttackHelper.evaluateConditions(attack.conditions(), player, isOffHandAttack)).toArray(WeaponAttributes.Attack[]::new);
        if (comboCount < 0) {
            comboCount = 0;
        }
        int index = comboCount % attacks.length;
        return attacks[index];
    }

    private static boolean evaluateConditions(WeaponAttributes.Condition[] conditions, class_1657 player, boolean isOffHandAttack) {
        return Arrays.stream(conditions).allMatch(condition -> PlayerAttackHelper.evaluateCondition(condition, player, isOffHandAttack));
    }

    private static boolean evaluateCondition(WeaponAttributes.Condition condition, class_1657 player, boolean isOffHandAttack) {
        if (condition == null) {
            return true;
        }
        switch (condition) {
            case NOT_DUAL_WIELDING: {
                return !PlayerAttackHelper.isDualWielding(player);
            }
            case DUAL_WIELDING_ANY: {
                return PlayerAttackHelper.isDualWielding(player);
            }
            case DUAL_WIELDING_SAME: {
                return PlayerAttackHelper.isDualWielding(player) && player.method_6047().method_7909() == player.method_6079().method_7909();
            }
            case DUAL_WIELDING_SAME_CATEGORY: {
                if (!PlayerAttackHelper.isDualWielding(player)) {
                    return false;
                }
                WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes(player.method_6047());
                WeaponAttributes offHandAttributes = WeaponRegistry.getAttributes(player.method_6079());
                if (mainHandAttributes.category() == null || mainHandAttributes.category().isEmpty() || offHandAttributes.category() == null || offHandAttributes.category().isEmpty()) {
                    return false;
                }
                return mainHandAttributes.category().equals(offHandAttributes.category());
            }
            case MAIN_HAND_ONLY: {
                return !isOffHandAttack;
            }
            case OFF_HAND_ONLY: {
                return isOffHandAttack;
            }
        }
        return true;
    }

    public static void setAttributesForOffHandAttack(class_1657 player, boolean useOffHand) {
        class_1799 add;
        class_1799 remove;
        class_1799 mainHandStack = player.method_6047();
        class_1799 offHandStack = player.method_6079();
        if (useOffHand) {
            remove = mainHandStack;
            add = offHandStack;
        } else {
            remove = offHandStack;
            add = mainHandStack;
        }
        if (remove != null) {
            player.method_6127().method_26847(remove.method_7926(class_1304.field_6173));
        }
        if (add != null) {
            player.method_6127().method_26854(add.method_7926(class_1304.field_6173));
        }
    }
}

