/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client.collision;

import java.util.List;
import java.util.stream.Collectors;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.collision.CollisionHelper;
import net.bettercombat.client.collision.OrientedBoundingBox;
import net.bettercombat.client.collision.WeaponHitBoxes;
import net.bettercombat.compatibility.CompatibilityFlags;
import net.bettercombat.compatibility.PehkuiHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_6025;

public class TargetFinder {
    public static TargetResult findAttackTargetResult(class_1657 player, class_1297 cursorTarget, WeaponAttributes.Attack attack, double attackRange) {
        class_243 origin = TargetFinder.getInitialTracingPoint(player);
        List<class_1297> entities = TargetFinder.getInitialTargets(player, cursorTarget, attackRange);
        if (CompatibilityFlags.usePehkui) {
            attackRange *= (double)PehkuiHelper.getScale((class_1297)player);
        }
        boolean isSpinAttack = attack.angle() > 180.0;
        class_243 size = WeaponHitBoxes.createHitbox(attack.hitbox(), attackRange, isSpinAttack);
        OrientedBoundingBox obb = new OrientedBoundingBox(origin, size, player.method_36455(), player.method_36454());
        if (!isSpinAttack) {
            obb = obb.offsetAlongAxisZ(size.field_1350 / 2.0);
        }
        obb.updateVertex();
        CollisionFilter collisionFilter = new CollisionFilter(obb);
        entities = collisionFilter.filter(entities);
        RadialFilter radialFilter = new RadialFilter(origin, obb.axisZ, attackRange, attack.angle());
        entities = radialFilter.filter(entities);
        return new TargetResult(entities, obb);
    }

    public static List<class_1297> findAttackTargets(class_1657 player, class_1297 cursorTarget, WeaponAttributes.Attack attack, double attackRange) {
        return TargetFinder.findAttackTargetResult((class_1657)player, (class_1297)cursorTarget, (WeaponAttributes.Attack)attack, (double)attackRange).entities;
    }

    public static class_243 getInitialTracingPoint(class_1657 player) {
        double shoulderHeight = (double)player.method_17682() * 0.2 * (double)player.method_17825();
        return player.method_33571().method_1023(0.0, shoulderHeight, 0.0);
    }

    public static List<class_1297> getInitialTargets(class_1657 player, class_1297 cursorTarget, double attackRange) {
        class_238 box = player.method_5829().method_1014(attackRange * (double)BetterCombat.config.target_search_range_multiplier + 1.0);
        List<class_1297> entities = player.field_6002.method_8333((class_1297)player, box, entity -> !entity.method_7325() && entity.method_5863()).stream().filter(entity -> {
            boolean result;
            boolean bl = result = entity != player && entity != cursorTarget && entity.method_5732() && (BetterCombat.config.allow_attacking_mount || !entity.equals((Object)player.method_5854()));
            if (entity instanceof class_6025) {
                class_6025 tameable = (class_6025)entity;
                result = result && tameable.method_6139() != null && !tameable.method_6139().equals(player.method_5667());
            }
            return result;
        }).collect(Collectors.toList());
        if (cursorTarget != null && cursorTarget.method_5732()) {
            entities.add(cursorTarget);
        }
        return entities;
    }

    public static class CollisionFilter
    implements Filter {
        private OrientedBoundingBox obb;

        public CollisionFilter(OrientedBoundingBox obb) {
            this.obb = obb;
        }

        @Override
        public List<class_1297> filter(List<class_1297> entities) {
            return entities.stream().filter((? super T entity) -> this.obb.intersects(entity.method_5829())).collect(Collectors.toList());
        }
    }

    public static class RadialFilter
    implements Filter {
        private final class_243 origin;
        private final class_243 orientation;
        private final double attackRange;
        private final double attackAngle;

        public RadialFilter(class_243 origin, class_243 orientation, double attackRange, double attackAngle) {
            this.origin = origin;
            this.orientation = orientation;
            this.attackRange = attackRange;
            this.attackAngle = class_3532.method_15350((double)attackAngle, (double)0.0, (double)360.0);
        }

        @Override
        public List<class_1297> filter(List<class_1297> entities) {
            return entities.stream().filter((? super T entity) -> {
                double maxAngleDif = this.attackAngle / 2.0;
                class_243 distanceVector = CollisionHelper.distanceVector(this.origin, entity.method_5829());
                class_243 positionVector = entity.method_19538().method_1020(this.origin);
                return distanceVector.method_1033() <= this.attackRange && (this.attackAngle == 0.0 || CollisionHelper.angleBetween(positionVector, this.orientation) <= maxAngleDif || CollisionHelper.angleBetween(distanceVector, this.orientation) <= maxAngleDif);
            }).collect(Collectors.toList());
        }
    }

    public static class TargetResult {
        public List<class_1297> entities;
        public OrientedBoundingBox obb;

        public TargetResult(List<class_1297> entities, OrientedBoundingBox obb) {
            this.entities = entities;
            this.obb = obb;
        }
    }

    public static interface Filter {
        public List<class_1297> filter(List<class_1297> var1);
    }
}

