/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.bettercombat.Platform;
import net.bettercombat.compatibility.CompatibilityFlags;
import net.bettercombat.config.FallbackConfig;
import net.bettercombat.config.ServerConfig;
import net.bettercombat.config.ServerConfigWrapper;
import net.bettercombat.logic.WeaponAttributesFallback;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.network.ServerNetwork;
import net.bettercombat.utils.SoundHelper;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.tinyconfig.ConfigManager;

public class BetterCombat
implements ModInitializer {
    public static final String MODID = "bettercombat";
    public static ServerConfig config;
    private static FallbackConfig fallbackDefault;
    public static ConfigManager<FallbackConfig> fallbackConfig;

    public void onInitialize() {
        AutoConfig.register(ServerConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        config = ((ServerConfigWrapper)AutoConfig.getConfigHolder(ServerConfigWrapper.class).getConfig()).server;
        this.loadFallbackConfig();
        CompatibilityFlags.initialize();
        ServerNetwork.initializeHandlers();
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            WeaponRegistry.loadAttributes(minecraftServer.method_34864());
            if (BetterCombat.config.fallback_compatibility_enabled) {
                WeaponAttributesFallback.initialize();
            }
            WeaponRegistry.encodeRegistry();
        });
        if (Platform.Fabric) {
            SoundHelper.registerSounds();
        }
    }

    private void loadFallbackConfig() {
        fallbackConfig.load();
        if (((FallbackConfig)BetterCombat.fallbackConfig.currentConfig).schema_version < BetterCombat.fallbackDefault.schema_version) {
            BetterCombat.fallbackConfig.currentConfig = FallbackConfig.migrate((FallbackConfig)BetterCombat.fallbackConfig.currentConfig, FallbackConfig.createDefault());
        }
        fallbackConfig.save();
    }

    static {
        fallbackDefault = FallbackConfig.createDefault();
        fallbackConfig = new ConfigManager("fallback_compatibility", (Object)fallbackDefault).builder().setDirectory(MODID).sanitize(true).build();
    }
}

