/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwWhip;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMcdwWeaponID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.items.ItemsInit;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum WhipsID implements IMcdwWeaponID,
IMeleeWeaponID
{
    WHIP_VINE_WHIP((class_1832)class_1834.field_8923, 5, -3.1f, "minecraft:vine"),
    WHIP_WHIP((class_1832)class_1834.field_8923, 3, -3.1f, "minecraft:string");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private WhipsID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<WhipsID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.WHIPS_ENABLED;
    }

    public static EnumMap<WhipsID, McdwWhip> getItemsEnum() {
        return ItemsInit.WHIP_ITEMS;
    }

    public static HashMap<WhipsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.WHIP_SPAWN_RATES;
    }

    public static HashMap<WhipsID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.whipStats;
    }

    @Override
    public Boolean isEnabled() {
        return WhipsID.getEnabledItems().get(this);
    }

    public McdwWhip getItem() {
        return WhipsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return WhipsID.getSpawnRates().get(this);
    }

    public HashMap<WhipsID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.whipStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return WhipsID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.whipStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwWhip makeWeapon() {
        McdwWhip mcdwWhip = new McdwWhip(ItemsInit.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        WhipsID.getItemsEnum().put(this, mcdwWhip);
        return mcdwWhip;
    }
}

