/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwPick;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMcdwWeaponID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.items.ItemsInit;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.class_1832;
import net.minecraft.class_1834;

public enum PicksID implements IMcdwWeaponID,
IMeleeWeaponID
{
    PICK_DIAMOND_PICKAXE_VAR((class_1832)class_1834.field_8930, 1, -2.8f, "minecraft:diamond"),
    PICK_HAILING_PINNACLE((class_1832)class_1834.field_8930, 1, -2.8f, "minecraft:diamond"),
    PICK_HOWLING_PICK((class_1832)class_1834.field_8923, 1, -2.8f, "minecraft:iron_ingot"),
    PICK_MOUNTAINEER_PICK((class_1832)class_1834.field_8923, 1, -2.8f, "minecraft:iron_ingot");

    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private PicksID(class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static HashMap<PicksID, Boolean> getEnabledItems() {
        return Mcdw.CONFIG.mcdwEnableItemsConfig.PICKS_ENABLED;
    }

    public static EnumMap<PicksID, McdwPick> getItemsEnum() {
        return ItemsInit.PICK_ITEMS;
    }

    public static HashMap<PicksID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.PICK_SPAWN_RATES;
    }

    public static HashMap<PicksID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.pickStats;
    }

    @Override
    public Boolean isEnabled() {
        return PicksID.getEnabledItems().get(this);
    }

    public McdwPick getItem() {
        return PicksID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return PicksID.getSpawnRates().get(this);
    }

    public HashMap<PicksID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.pickStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return PicksID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.pickStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    public McdwPick makeWeapon() {
        McdwPick mcdwPick = new McdwPick(ItemsInit.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        PicksID.getItemsEnum().put(this, mcdwPick);
        return mcdwPick;
    }
}

