/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.authme.settings;

import java.io.File;
import org.bukkit.util.config.Configuration;

public final class Settings
extends Configuration {
    public static final String PLUGIN_FOLDER = "./plugins/AuthMe";
    public static final String CACHE_FOLDER = "./plugins/AuthMe/cache";
    public static final String AUTH_FILE = "./plugins/AuthMe/auths.db";
    public static final String MESSAGE_FILE = "./plugins/AuthMe/messages.yml";
    public static final String SETTINGS_FILE = "./plugins/AuthMe/config.yml";
    private static Settings singleton;

    private Settings() {
        super(new File(SETTINGS_FILE));
        this.reload();
    }

    public void reload() {
        this.load();
        this.write();
    }

    private void write() {
        this.isRegistrationEnabled();
        this.isForcedRegistrationEnabled();
        this.isTeleportToSpawnEnabled();
        this.getWarnMessageInterval();
        this.isSessionsEnabled();
        this.getRegistrationTimeout();
        this.isChatAllowed();
        this.getMaxNickLength();
        this.getMinNickLength();
        this.isMovementAllowed();
        this.getMovementRadius();
        this.isKickNonRegisteredEnabled();
        this.getPasswordHash();
        this.getDataSource();
        this.isCachingEnabled();
        this.getMySQLHost();
        this.getMySQLPort();
        this.getMySQLUsername();
        this.getMySQLPassword();
        this.getMySQLDatabase();
        this.getMySQLTablename();
        this.getMySQLColumnName();
        this.getMySQLColumnPassword();
        this.save();
    }

    public boolean isForcedRegistrationEnabled() {
        String key = "settings.registration.force";
        if (this.getString(key) == null) {
            this.setProperty(key, true);
        }
        return this.getBoolean(key, true);
    }

    public boolean isRegistrationEnabled() {
        String key = "settings.registration.enabled";
        if (this.getString(key) == null) {
            this.setProperty(key, true);
        }
        return this.getBoolean(key, true);
    }

    public int getWarnMessageInterval() {
        String key = "settings.registration.messageInterval";
        if (this.getString(key) == null) {
            this.setProperty(key, 5);
        }
        return this.getInt(key, 5);
    }

    public boolean isSessionsEnabled() {
        String key = "settings.sessions";
        if (this.getString(key) == null) {
            this.setProperty(key, false);
        }
        return this.getBoolean(key, false);
    }

    public boolean isKickOnWrongPasswordEnabled() {
        String key = "settings.restrictions.kickOnWrongPassword";
        if (this.getString(key) == null) {
            this.setProperty(key, false);
        }
        return this.getBoolean(key, false);
    }

    public int getMinNickLength() {
        String key = "settings.restrictions.minNicknameLength";
        if (this.getString(key) == null) {
            this.setProperty(key, 3);
        }
        return this.getInt(key, 3);
    }

    public int getMaxNickLength() {
        String key = "settings.restrictions.maxNicknameLength";
        if (this.getString(key) == null) {
            this.setProperty(key, 20);
        }
        return this.getInt(key, 20);
    }

    public String getNickRegex() {
        String key = "settings.restrictions.allowedNicknameCharacters";
        if (this.getString(key) == null) {
            this.setProperty(key, "[a-zA-Z0-9_?]*");
        }
        return this.getString(key, "[a-zA-Z0-9_?]*");
    }

    public int getRegistrationTimeout() {
        String key = "settings.restrictions.timeout";
        if (this.getString(key) == null) {
            this.setProperty(key, 30);
        }
        return this.getInt(key, 30);
    }

    public boolean isChatAllowed() {
        String key = "settings.restrictions.allowChat";
        if (this.getString(key) == null) {
            this.setProperty(key, false);
        }
        return this.getBoolean(key, false);
    }

    public boolean isMovementAllowed() {
        String key = "settings.restrictions.allowMovement";
        if (this.getString(key) == null) {
            this.setProperty(key, false);
        }
        return this.getBoolean(key, false);
    }

    public int getMovementRadius() {
        String key = "settings.restrictions.allowedMovementRadius";
        if (this.getString(key) == null) {
            this.setProperty(key, 100);
        }
        return this.getInt(key, 100);
    }

    public boolean isKickNonRegisteredEnabled() {
        String key = "settings.restrictions.kickNonRegistered";
        if (this.getString(key) == null) {
            this.setProperty(key, false);
        }
        return this.getBoolean(key, false);
    }

    public boolean isTeleportToSpawnEnabled() {
        String key = "settings.restrictions.teleportUnAuthedToSpawn";
        if (this.getString(key) == null) {
            this.setProperty(key, true);
        }
        return this.getBoolean(key, true);
    }

    public int getPasswordHash() {
        String entry;
        String key = "settings.security.passwordHash";
        if (this.getString(key) == null) {
            this.setProperty(key, "SHA256");
        }
        if ((entry = this.getString(key)).equals("MD5")) {
            return 1;
        }
        if (entry.equals("SHA1")) {
            return 2;
        }
        if (entry.equals("SHA256")) {
            return 3;
        }
        return 0;
    }

    public boolean isCachingEnabled() {
        String key = "DataSource.caching";
        if (this.getString(key) == null) {
            this.setProperty(key, true);
        }
        return this.getBoolean(key, true);
    }

    public String getDataSource() {
        String key = "DataSource.backend";
        if (this.getString(key) == null) {
            this.setProperty(key, "file");
        }
        return this.getString(key);
    }

    public String getMySQLHost() {
        String key = "DataSource.mySQLHost";
        if (this.getString(key) == null) {
            this.setProperty(key, "127.0.0.1");
        }
        return this.getString(key);
    }

    public String getMySQLPort() {
        String key = "DataSource.mySQLPort";
        if (this.getString(key) == null) {
            this.setProperty(key, "3306");
        }
        return this.getString(key);
    }

    public String getMySQLUsername() {
        String key = "DataSource.mySQLUsername";
        if (this.getString(key) == null) {
            this.setProperty(key, "authme");
        }
        return this.getString(key);
    }

    public String getMySQLPassword() {
        String key = "DataSource.mySQLPassword";
        if (this.getString(key) == null) {
            this.setProperty(key, "12345");
        }
        return this.getString(key);
    }

    public String getMySQLDatabase() {
        String key = "DataSource.mySQLDatabase";
        if (this.getString(key) == null) {
            this.setProperty(key, "authme");
        }
        return this.getString(key);
    }

    public String getMySQLTablename() {
        String key = "DataSource.mySQLTablename";
        if (this.getString(key) == null) {
            this.setProperty(key, "authme");
        }
        return this.getString(key);
    }

    public String getMySQLColumnName() {
        String key = "DataSource.mySQLColumnName";
        if (this.getString(key) == null) {
            this.setProperty(key, "username");
        }
        return this.getString(key);
    }

    public String getMySQLColumnPassword() {
        String key = "DataSource.mySQLColumnPassword";
        if (this.getString(key) == null) {
            this.setProperty(key, "password");
        }
        return this.getString(key);
    }

    public static Settings getInstance() {
        if (singleton == null) {
            singleton = new Settings();
        }
        return singleton;
    }
}

