/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.authme.settings;

import java.io.File;
import java.util.HashMap;
import org.bukkit.util.config.Configuration;

public class Messages
extends Configuration {
    private static Messages singleton = null;
    private HashMap<String, String> map = new HashMap();

    private Messages() {
        super(new File("./plugins/AuthMe/messages.yml"));
        this.loadDefaults();
        this.loadFile();
    }

    private void loadDefaults() {
        this.map.put("logged_in", "&cAlready logged in!");
        this.map.put("not_logged_in", "&cNot logged in!");
        this.map.put("reg_disabled", "&cRegistration is disabled");
        this.map.put("user_regged", "&cUsername already registered");
        this.map.put("usage_reg", "&cUsage: /register password");
        this.map.put("usage_log", "&cUsage: /login password");
        this.map.put("user_unknown", "&cUsername not registered");
        this.map.put("pwd_changed", "&cPassword changed!");
        this.map.put("reg_only", "Registered players only! Please visit http://example.com to register");
        this.map.put("valid_session", "&cSession login");
        this.map.put("login_msg", "&cPlease login with \"/login password\"");
        this.map.put("reg_msg", "&cPlease register with \"/register password\"");
        this.map.put("timeout", "Login Timeout");
        this.map.put("wrong_pwd", "&cWrong password");
        this.map.put("logout", "&cSuccessful logout");
        this.map.put("usage_unreg", "&cUsage: /unregister password");
        this.map.put("registered", "&cSuccessfully registered!");
        this.map.put("unregistered", "&cSuccessfully unregistered!");
        this.map.put("login", "&cSuccessful login!");
        this.map.put("no_perm", "&cNo Permission");
        this.map.put("same_nick", "Same nick is already playing");
        this.map.put("reg_voluntarily", "You can register your nickname with the server with the command \"/register password\"");
        this.map.put("reload", "Configuration and database has been reloaded");
    }

    private void loadFile() {
        this.load();
        for (String key : this.map.keySet()) {
            if (this.getString(key) == null) {
                this.setProperty(key, this.map.get(key));
                continue;
            }
            this.map.put(key, this.getString(key));
        }
        this.save();
    }

    public String _(String msg) {
        String loc = this.map.get(msg);
        if (loc != null) {
            return loc.replace("&", "\u00a7");
        }
        return msg;
    }

    public void reload() {
        this.loadFile();
    }

    public static Messages getInstance() {
        if (singleton == null) {
            singleton = new Messages();
        }
        return singleton;
    }
}

