/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.authme.security;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import uk.org.whoami.authme.ConsoleLogger;

public class PasswordSecurity {
    public static final int MD5 = 1;
    public static final int SHA1 = 2;
    public static final int SHA256 = 3;
    private MessageDigest md5;
    private MessageDigest sha256;
    private MessageDigest sha1;
    private int hash;

    public PasswordSecurity(int hash) throws NoSuchAlgorithmException {
        if (hash < 1 || hash > 3) {
            throw new NoSuchAlgorithmException("Unknown hash");
        }
        this.hash = hash;
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha256 = MessageDigest.getInstance("SHA-256");
            this.sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException ex) {
            ConsoleLogger.showError(ex.getMessage());
        }
    }

    private String getMD5(String message) {
        this.md5.reset();
        this.md5.update(message.getBytes());
        byte[] digest = this.md5.digest();
        return String.format("%0" + (digest.length << 1) + "x", new BigInteger(1, digest));
    }

    private String getSHA1(String message) {
        this.sha1.reset();
        this.sha1.update(message.getBytes());
        byte[] digest = this.sha1.digest();
        return String.format("%0" + (digest.length << 1) + "x", new BigInteger(1, digest));
    }

    private String getSHA256(String message) {
        this.sha256.reset();
        this.sha256.update(message.getBytes());
        byte[] digest = this.sha256.digest();
        return String.format("%0" + (digest.length << 1) + "x", new BigInteger(1, digest));
    }

    private String getSaltedHash(String message, String salt) {
        return "$SHA$" + salt + "$" + this.getSHA256(this.getSHA256(message) + salt);
    }

    public String getHash(String password) {
        if (this.hash == 1) {
            return this.getMD5(password);
        }
        if (this.hash == 2) {
            return this.getSHA1(password);
        }
        String salt = Long.toHexString(Double.doubleToLongBits(Math.random()));
        return this.getSaltedHash(password, salt);
    }

    public boolean comparePasswordWithHash(String password, String hash) {
        if (hash.length() == 32) {
            return hash.equals(this.getMD5(password));
        }
        if (hash.length() == 40) {
            return hash.equals(this.getSHA1(password));
        }
        if (hash.contains("$")) {
            String[] line = hash.split("\\$");
            if (line.length > 3 && line[1].equals("SHA")) {
                return hash.equals(this.getSaltedHash(password, line[2]));
            }
            return false;
        }
        return false;
    }
}

