/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.authme.listener;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import uk.org.whoami.authme.cache.auth.PlayerAuth;
import uk.org.whoami.authme.cache.auth.PlayerCache;
import uk.org.whoami.authme.cache.inventory.LimboCache;
import uk.org.whoami.authme.cache.inventory.LimboPlayer;
import uk.org.whoami.authme.datasource.DataSource;
import uk.org.whoami.authme.settings.Messages;
import uk.org.whoami.authme.settings.Settings;
import uk.org.whoami.authme.task.MessageTask;
import uk.org.whoami.authme.task.TimeoutTask;

public class AuthMePlayerListener
extends PlayerListener {
    private Settings settings = Settings.getInstance();
    private Messages m = Messages.getInstance();
    private JavaPlugin plugin;
    private DataSource data;

    public AuthMePlayerListener(JavaPlugin plugin, DataSource data) {
        this.data = data;
        this.plugin = plugin;
    }

    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (PlayerCache.getInstance().isAuthenticated(name)) {
            return;
        }
        if (!this.data.isAuthAvailable(name) && !this.settings.isForcedRegistrationEnabled()) {
            return;
        }
        String cmd = event.getMessage().split(" ")[0];
        if (cmd.equalsIgnoreCase("/login") || cmd.equalsIgnoreCase("/register")) {
            return;
        }
        event.setMessage("/notloggedin");
        event.setCancelled(true);
    }

    public void onPlayerChat(PlayerChatEvent event) {
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (PlayerCache.getInstance().isAuthenticated(name)) {
            return;
        }
        if (this.data.isAuthAvailable(name)) {
            player.sendMessage(this.m._("login_msg"));
        } else {
            if (!this.settings.isForcedRegistrationEnabled()) {
                return;
            }
            if (this.settings.isChatAllowed()) {
                return;
            }
            player.sendMessage(this.m._("reg_msg"));
        }
        event.setCancelled(true);
    }

    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (PlayerCache.getInstance().isAuthenticated(name)) {
            return;
        }
        if (!this.data.isAuthAvailable(name)) {
            if (!this.settings.isForcedRegistrationEnabled()) {
                return;
            }
            if (this.settings.isMovementAllowed()) {
                if (this.settings.getMovementRadius() > 0) {
                    int radius = this.settings.getMovementRadius();
                    System.out.println(radius);
                    Location spawn = player.getWorld().getSpawnLocation();
                    Location to = event.getTo();
                    if (to.getX() > spawn.getX() + (double)radius || to.getX() < spawn.getX() - (double)radius) {
                        event.setCancelled(true);
                    }
                    if (to.getY() > spawn.getY() + (double)radius || to.getY() < spawn.getY() - (double)radius) {
                        event.setCancelled(true);
                    }
                    if (to.getZ() > spawn.getZ() + (double)radius || to.getZ() < spawn.getZ() - (double)radius) {
                        event.setCancelled(true);
                    }
                    event.setTo(to);
                }
                return;
            }
        }
        event.setTo(event.getFrom());
    }

    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        int min = this.settings.getMinNickLength();
        int max = this.settings.getMaxNickLength();
        String regex = this.settings.getNickRegex();
        if (name.length() > max || name.length() < min) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "Your nickname has the wrong length. MaxLen: " + max + ", MinLen: " + min);
            return;
        }
        if (!player.getName().matches(regex) || name.equals("Player")) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, "Your nickname contains illegal characters. Allowed chars: " + regex);
            return;
        }
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (!onlinePlayer.getName().equals(player.getName())) continue;
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.m._("same_nick"));
            return;
        }
        if (this.settings.isKickNonRegisteredEnabled() && !this.data.isAuthAvailable(name)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.m._("reg_only"));
            return;
        }
    }

    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        String ip = player.getAddress().getAddress().getHostAddress();
        if (PlayerCache.getInstance().isAuthenticated(name)) {
            return;
        }
        if (this.data.isAuthAvailable(name)) {
            PlayerAuth auth;
            if (this.settings.isSessionsEnabled() && (auth = this.data.getAuth(name)).getNickname().equals(name) && auth.getIp().equals(ip)) {
                PlayerCache.getInstance().addPlayer(auth);
                player.sendMessage(this.m._("valid_session"));
                return;
            }
        } else if (!this.settings.isForcedRegistrationEnabled()) {
            return;
        }
        LimboCache.getInstance().addLimboPlayer(player);
        player.getInventory().setArmorContents(new ItemStack[0]);
        player.getInventory().setContents(new ItemStack[36]);
        if (this.settings.isTeleportToSpawnEnabled()) {
            player.teleport(player.getWorld().getSpawnLocation());
        }
        String msg = this.data.isAuthAvailable(name) ? this.m._("login_msg") : this.m._("reg_msg");
        int time = this.settings.getRegistrationTimeout() * 20;
        int msgInterval = this.settings.getWarnMessageInterval();
        BukkitScheduler sched = this.plugin.getServer().getScheduler();
        if (time != 0) {
            int id = sched.scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new TimeoutTask(this.plugin, name), (long)time);
            LimboCache.getInstance().getLimboPlayer(name).setTimeoutTaskId(id);
        }
        sched.scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new MessageTask(this.plugin, name, msg, msgInterval));
    }

    public void onPlayerQuit(PlayerQuitEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (LimboCache.getInstance().hasLimboPlayer(name)) {
            LimboPlayer limbo = LimboCache.getInstance().getLimboPlayer(name);
            player.getInventory().setArmorContents(limbo.getArmour());
            player.getInventory().setContents(limbo.getInventory());
            player.teleport(limbo.getLoc());
            this.plugin.getServer().getScheduler().cancelTask(limbo.getTimeoutTaskId());
            LimboCache.getInstance().deleteLimboPlayer(name);
        }
        PlayerCache.getInstance().removePlayer(name);
    }

    public void onPlayerKick(PlayerKickEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (LimboCache.getInstance().hasLimboPlayer(name)) {
            LimboPlayer limbo = LimboCache.getInstance().getLimboPlayer(name);
            player.getInventory().setArmorContents(limbo.getArmour());
            player.getInventory().setContents(limbo.getInventory());
            player.teleport(limbo.getLoc());
            this.plugin.getServer().getScheduler().cancelTask(limbo.getTimeoutTaskId());
            LimboCache.getInstance().deleteLimboPlayer(name);
        }
        PlayerCache.getInstance().removePlayer(name);
    }

    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (PlayerCache.getInstance().isAuthenticated(player.getName().toLowerCase())) {
            return;
        }
        if (!this.data.isAuthAvailable(name) && !this.settings.isForcedRegistrationEnabled()) {
            return;
        }
        event.setCancelled(true);
    }

    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (PlayerCache.getInstance().isAuthenticated(player.getName().toLowerCase())) {
            return;
        }
        if (!this.data.isAuthAvailable(name) && !this.settings.isForcedRegistrationEnabled()) {
            return;
        }
        event.setCancelled(true);
    }

    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (this.settings.isTeleportToSpawnEnabled() && event.getTo().equals((Object)player.getWorld().getSpawnLocation())) {
            return;
        }
        if (PlayerCache.getInstance().isAuthenticated(player.getName().toLowerCase())) {
            return;
        }
        if (!this.data.isAuthAvailable(name) && !this.settings.isForcedRegistrationEnabled()) {
            return;
        }
        event.setCancelled(true);
    }

    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (PlayerCache.getInstance().isAuthenticated(player.getName().toLowerCase())) {
            return;
        }
        if (!this.data.isAuthAvailable(name) && !this.settings.isForcedRegistrationEnabled()) {
            return;
        }
        event.setCancelled(true);
    }

    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (PlayerCache.getInstance().isAuthenticated(player.getName().toLowerCase())) {
            return;
        }
        if (!this.data.isAuthAvailable(name) && !this.settings.isForcedRegistrationEnabled()) {
            return;
        }
        event.setCancelled(true);
    }

    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (event.isCancelled() || event.getPlayer() == null) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        if (PlayerCache.getInstance().isAuthenticated(player.getName().toLowerCase())) {
            return;
        }
        if (!this.data.isAuthAvailable(name) && !this.settings.isForcedRegistrationEnabled()) {
            return;
        }
        event.setCancelled(true);
    }
}

