/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.authme.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import uk.org.whoami.authme.ConsoleLogger;
import uk.org.whoami.authme.cache.auth.PlayerAuth;
import uk.org.whoami.authme.datasource.DataSource;
import uk.org.whoami.authme.settings.Settings;

public class MySQLDataSource
implements DataSource {
    private String host;
    private String port;
    private String username;
    private String password;
    private String database;
    private String tableName;
    private String columnName;
    private String columnPassword;
    private Connection con;

    public MySQLDataSource() throws ClassNotFoundException, SQLException {
        Settings s = Settings.getInstance();
        this.host = s.getMySQLHost();
        this.port = s.getMySQLPort();
        this.username = s.getMySQLUsername();
        this.password = s.getMySQLPassword();
        this.database = s.getMySQLDatabase();
        this.tableName = s.getMySQLTablename();
        this.columnName = s.getMySQLColumnName();
        this.columnPassword = s.getMySQLColumnPassword();
        this.connect();
        this.setup();
    }

    private synchronized void connect() throws ClassNotFoundException, SQLException {
        Class.forName("com.mysql.jdbc.Driver");
        ConsoleLogger.info("MySQL driver loaded");
        this.con = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database, this.username, this.password);
        ConsoleLogger.info("Connected to MySQL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setup() throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.con.createStatement();
            st.executeUpdate("CREATE TABLE IF NOT EXISTS " + this.tableName + " (" + "id INTEGER AUTO_INCREMENT," + this.columnName + " VARCHAR(20) NOT NULL," + this.columnPassword + " VARCHAR(100) NOT NULL," + "ip VARCHAR(40) NOT NULL," + "CONSTRAINT table_const_prim PRIMARY KEY (id));");
            rs = this.con.getMetaData().getColumns(null, null, this.tableName, "ip");
            if (!rs.next()) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + "ip VARCHAR(40) NOT NULL;");
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException ex) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        ConsoleLogger.info("MySQL Setup finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isAuthAvailable(String user) {
        Statement pst = null;
        try {
            pst = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE " + this.columnName + "=?;");
            pst.setString(1, user);
            ResultSet rs = pst.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (SQLException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PlayerAuth getAuth(String user) {
        Statement pst = null;
        try {
            pst = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE " + this.columnName + "=?;");
            pst.setString(1, user);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                if (rs.getString(3).isEmpty()) {
                    PlayerAuth playerAuth = new PlayerAuth(rs.getString(2), rs.getString(3), "198.18.0.1");
                    return playerAuth;
                }
                PlayerAuth playerAuth = new PlayerAuth(rs.getString(2), rs.getString(3), rs.getString(4));
                return playerAuth;
            }
            PlayerAuth playerAuth = null;
            return playerAuth;
        }
        catch (SQLException ex) {
            ConsoleLogger.showError(ex.getMessage());
            PlayerAuth playerAuth = null;
            return playerAuth;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean saveAuth(PlayerAuth auth) {
        Statement pst = null;
        try {
            pst = this.con.prepareStatement("INSERT INTO " + this.tableName + "(" + this.columnName + "," + this.columnPassword + ",ip) VALUES (?,?,?);");
            pst.setString(1, auth.getNickname());
            pst.setString(2, auth.getHash());
            pst.setString(3, auth.getIp());
            pst.executeUpdate();
        }
        catch (SQLException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException ex) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean updateIP(PlayerAuth auth) {
        Statement pst = null;
        try {
            pst = this.con.prepareStatement("UPDATE " + this.tableName + " SET ip=? WHERE " + this.columnName + "=?;");
            pst.setString(1, auth.getIp());
            pst.setString(2, auth.getNickname());
            pst.executeUpdate();
        }
        catch (SQLException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException ex) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean updatePassword(PlayerAuth auth) {
        Statement pst = null;
        try {
            pst = this.con.prepareStatement("UPDATE " + this.tableName + " SET " + this.columnPassword + "=? WHERE " + this.columnName + "=?;");
            pst.setString(1, auth.getHash());
            pst.setString(2, auth.getNickname());
            pst.executeUpdate();
        }
        catch (SQLException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException ex) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean removeAuth(String user) {
        Statement pst = null;
        try {
            pst = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE " + this.columnName + "=?;");
            pst.setString(1, user);
            pst.executeUpdate();
        }
        catch (SQLException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException ex) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HashMap<String, PlayerAuth> getAllRegisteredUsers() {
        HashMap<String, PlayerAuth> map = new HashMap<String, PlayerAuth>();
        Statement pst = null;
        try {
            pst = this.con.prepareStatement("SELECT * FROM " + this.tableName + ";");
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                if (rs.getString(3).isEmpty()) {
                    map.put(rs.getString(2), new PlayerAuth(rs.getString(2), rs.getString(3), "198.18.0.1"));
                    continue;
                }
                map.put(rs.getString(2), new PlayerAuth(rs.getString(2), rs.getString(3), rs.getString(4)));
            }
        }
        catch (SQLException ex) {
            ConsoleLogger.showError(ex.getMessage());
            HashMap<String, PlayerAuth> hashMap = map;
            return hashMap;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException ex) {}
            }
        }
        return map;
    }

    @Override
    public synchronized void close() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException ex) {
                ConsoleLogger.showError("Couldn't close MySQL connection");
            }
        }
    }

    @Override
    public void reload() {
    }
}

