/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.authme.datasource;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import uk.org.whoami.authme.ConsoleLogger;
import uk.org.whoami.authme.cache.auth.PlayerAuth;
import uk.org.whoami.authme.datasource.DataSource;

public class FileDataSource
implements DataSource {
    private File source = new File("./plugins/AuthMe/auths.db");

    public FileDataSource() throws IOException {
        this.source.createNewFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean isAuthAvailable(String user) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.source));
            while (true) {
                String line;
                if ((line = br.readLine()) != null) {
                    String[] args = line.split(":");
                    if (args.length <= 1 || !args[0].equals(user)) continue;
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean saveAuth(PlayerAuth auth) {
        if (this.isAuthAvailable(auth.getNickname())) {
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(this.source, true));
            bw.write(auth.getNickname() + ":" + auth.getHash() + ":" + auth.getIp() + "\n");
        }
        catch (IOException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ex) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean updateIP(PlayerAuth auth) {
        if (!this.isAuthAvailable(auth.getNickname())) {
            return false;
        }
        PlayerAuth newAuth = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.source));
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equals(auth.getNickname())) continue;
                newAuth = new PlayerAuth(args[0], args[1], auth.getIp());
                break;
            }
        }
        catch (FileNotFoundException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
        this.removeAuth(auth.getNickname());
        this.saveAuth(newAuth);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean updatePassword(PlayerAuth auth) {
        if (!this.isAuthAvailable(auth.getNickname())) {
            return false;
        }
        PlayerAuth newAuth = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.source));
            String line = "";
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equals(auth.getNickname())) continue;
                newAuth = new PlayerAuth(args[0], auth.getHash(), args[2]);
                break;
            }
        }
        catch (FileNotFoundException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
        this.removeAuth(auth.getNickname());
        this.saveAuth(newAuth);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean removeAuth(String user) {
        if (!this.isAuthAvailable(user)) {
            return false;
        }
        BufferedReader br = null;
        BufferedWriter bw = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (args.length <= 1 || args[0].equals(user)) continue;
                lines.add(line);
            }
            bw = new BufferedWriter(new FileWriter(this.source));
            for (String l : lines) {
                bw.write(l + "\n");
            }
        }
        catch (FileNotFoundException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ConsoleLogger.showError(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException ex) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized PlayerAuth getAuth(String user) {
        PlayerAuth playerAuth;
        BufferedReader br = null;
        try {
            String[] args;
            br = new BufferedReader(new FileReader(this.source));
            do {
                String line;
                if ((line = br.readLine()) == null) return null;
                args = line.split(":");
                if (args.length != 2) continue;
                PlayerAuth playerAuth2 = new PlayerAuth(args[0], args[1], "198.18.0.1");
                return playerAuth2;
            } while (args.length != 3);
            PlayerAuth playerAuth3 = new PlayerAuth(args[0], args[1], args[2]);
            return playerAuth3;
        }
        catch (FileNotFoundException ex) {
            ConsoleLogger.showError(ex.getMessage());
            playerAuth = null;
            return playerAuth;
        }
        catch (IOException ex) {
            ConsoleLogger.showError(ex.getMessage());
            playerAuth = null;
            return playerAuth;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HashMap<String, PlayerAuth> getAllRegisteredUsers() {
        HashMap<String, PlayerAuth> map = new HashMap<String, PlayerAuth>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (args.length == 2) {
                    map.put(args[0], new PlayerAuth(args[0], args[1], "198.18.0.1"));
                    continue;
                }
                if (args.length != 3) continue;
                map.put(args[0], new PlayerAuth(args[0], args[1], args[2]));
            }
        }
        catch (FileNotFoundException ex) {
            ConsoleLogger.showError(ex.getMessage());
            HashMap<String, PlayerAuth> hashMap = map;
            return hashMap;
        }
        catch (IOException ex) {
            ConsoleLogger.showError(ex.getMessage());
            HashMap<String, PlayerAuth> hashMap = map;
            return hashMap;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {}
            }
        }
        return map;
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public void reload() {
    }
}

