/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.authme.datasource;

import java.util.HashMap;
import uk.org.whoami.authme.cache.auth.PlayerAuth;
import uk.org.whoami.authme.datasource.DataSource;

public class CacheDataSource
implements DataSource {
    private DataSource source;
    private HashMap<String, PlayerAuth> cache;

    public CacheDataSource(DataSource source) {
        this.source = source;
        this.cache = source.getAllRegisteredUsers();
    }

    @Override
    public synchronized boolean isAuthAvailable(String user) {
        return this.cache.containsKey(user);
    }

    @Override
    public synchronized PlayerAuth getAuth(String user) {
        return this.cache.get(user);
    }

    @Override
    public synchronized boolean saveAuth(PlayerAuth auth) {
        if (this.source.saveAuth(auth)) {
            this.cache.put(auth.getNickname(), auth);
        }
        return false;
    }

    @Override
    public synchronized boolean updateIP(PlayerAuth auth) {
        if (this.source.updateIP(auth)) {
            this.cache.get(auth.getNickname()).setIp(auth.getIp());
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean updatePassword(PlayerAuth auth) {
        if (this.source.updatePassword(auth)) {
            this.cache.get(auth.getNickname()).setHash(auth.getHash());
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAuth(String user) {
        if (this.source.removeAuth(user)) {
            this.cache.remove(user);
            return true;
        }
        return false;
    }

    @Override
    public synchronized HashMap<String, PlayerAuth> getAllRegisteredUsers() {
        return this.cache;
    }

    @Override
    public synchronized void close() {
        this.source.close();
    }

    @Override
    public void reload() {
        this.cache = this.source.getAllRegisteredUsers();
    }
}

