/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.authme.cache.auth;

import java.util.HashMap;
import uk.org.whoami.authme.cache.auth.PlayerAuth;

public class PlayerCache {
    private static PlayerCache singleton = null;
    private HashMap<String, PlayerAuth> cache = new HashMap();

    private PlayerCache() {
    }

    public void addPlayer(String user, String hash, String ip) {
        PlayerAuth tmp = new PlayerAuth(user, hash, ip);
        this.cache.put(user, tmp);
    }

    public void addPlayer(PlayerAuth auth) {
        this.cache.put(auth.getNickname(), auth);
    }

    public void updatePlayer(PlayerAuth auth) {
        this.cache.remove(auth.getNickname());
        this.cache.put(auth.getNickname(), auth);
    }

    public void removePlayer(String user) {
        this.cache.remove(user);
    }

    public boolean isAuthenticated(String user) {
        return this.cache.containsKey(user);
    }

    public PlayerAuth getAuth(String user) {
        return this.cache.get(user);
    }

    public static PlayerCache getInstance() {
        if (singleton == null) {
            singleton = new PlayerCache();
        }
        return singleton;
    }
}

