/*
 * Decompiled with CFR 0.152.
 */
package uk.org.whoami.authme;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import uk.org.whoami.authme.ConsoleLogger;
import uk.org.whoami.authme.cache.auth.PlayerAuth;
import uk.org.whoami.authme.cache.auth.PlayerCache;
import uk.org.whoami.authme.cache.inventory.LimboCache;
import uk.org.whoami.authme.cache.inventory.LimboPlayer;
import uk.org.whoami.authme.datasource.CacheDataSource;
import uk.org.whoami.authme.datasource.DataSource;
import uk.org.whoami.authme.datasource.FileDataSource;
import uk.org.whoami.authme.datasource.MySQLDataSource;
import uk.org.whoami.authme.listener.AuthMeBlockListener;
import uk.org.whoami.authme.listener.AuthMeEntityListener;
import uk.org.whoami.authme.listener.AuthMePlayerListener;
import uk.org.whoami.authme.security.PasswordSecurity;
import uk.org.whoami.authme.settings.Messages;
import uk.org.whoami.authme.settings.Settings;
import uk.org.whoami.authme.task.MessageTask;
import uk.org.whoami.authme.task.TimeoutTask;

public class AuthMe
extends JavaPlugin {
    private DataSource database;
    private Settings settings;
    private Messages m;
    private PasswordSecurity pws;

    public void onEnable() {
        this.settings = Settings.getInstance();
        if (this.settings.getDataSource().equals("file")) {
            try {
                this.database = new FileDataSource();
            }
            catch (IOException ex) {
                ConsoleLogger.showError(ex.getMessage());
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else if (this.settings.getDataSource().equals("mysql")) {
            try {
                this.database = new MySQLDataSource();
            }
            catch (ClassNotFoundException ex) {
                ConsoleLogger.showError(ex.getMessage());
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
            catch (SQLException ex) {
                ConsoleLogger.showError(ex.getMessage());
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else {
            ConsoleLogger.showError("Unknown database type");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.settings.isCachingEnabled()) {
            this.database = new CacheDataSource(this.database);
        }
        this.m = Messages.getInstance();
        try {
            this.pws = new PasswordSecurity(this.settings.getPasswordHash());
        }
        catch (NoSuchAlgorithmException ex) {
            ConsoleLogger.showError(ex.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        AuthMePlayerListener playerListener = new AuthMePlayerListener(this, this.database);
        AuthMeBlockListener blockListener = new AuthMeBlockListener(this.database);
        AuthMeEntityListener entityListener = new AuthMeEntityListener(this.database);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_COMMAND_PREPROCESS, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_CHAT, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_MOVE, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_LOGIN, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_JOIN, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_QUIT, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_KICK, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_TELEPORT, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_PICKUP_ITEM, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_INTERACT_ENTITY, (Listener)playerListener, Event.Priority.Low, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_DROP_ITEM, (Listener)playerListener, Event.Priority.Low, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_BED_ENTER, (Listener)playerListener, Event.Priority.Low, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)blockListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)blockListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.ENTITY_DAMAGE, (Listener)entityListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.ENTITY_TARGET, (Listener)entityListener, Event.Priority.Lowest, (Plugin)this);
        ConsoleLogger.info("Authme " + this.getDescription().getVersion() + " enabled");
    }

    public void onDisable() {
        if (this.database != null) {
            this.database.close();
        }
        ConsoleLogger.info("Authme " + this.getDescription().getVersion() + " disabled");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (label.equalsIgnoreCase("authme")) {
            if (args.length == 0) {
                sender.sendMessage("Usage: /authme reload|register playername password|changepassword playername password|unregister playername");
                return true;
            }
            if (!sender.hasPermission("authme.admin." + args[0].toLowerCase())) {
                sender.sendMessage(this.m._("no_perm"));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                this.database.reload();
                this.settings.reload();
                this.m.reload();
                sender.sendMessage(this.m._("reload"));
            } else if (args[0].equalsIgnoreCase("register")) {
                if (args.length != 3) {
                    sender.sendMessage("Usage: /authme register playername password");
                    return true;
                }
                String name = args[1].toLowerCase();
                String hash = this.pws.getHash(args[2]);
                if (this.database.isAuthAvailable(name)) {
                    sender.sendMessage(this.m._("user_regged"));
                    return true;
                }
                PlayerAuth auth = new PlayerAuth(name, hash, "198.18.0.1");
                this.database.saveAuth(auth);
                sender.sendMessage(this.m._("registered"));
                ConsoleLogger.info(args[1] + " registered");
            } else if (args[0].equalsIgnoreCase("changepassword")) {
                if (args.length != 3) {
                    sender.sendMessage("Usage: /authme changepassword playername newpassword");
                    return true;
                }
                String name = args[1].toLowerCase();
                String hash = this.pws.getHash(args[2]);
                PlayerAuth auth = new PlayerAuth(name, hash, "198.18.0.1");
                this.database.updatePassword(auth);
                sender.sendMessage("pwd_changed");
                ConsoleLogger.info(args[0] + "'s password changed");
            } else if (args[0].equalsIgnoreCase("unregister")) {
                if (args.length != 2) {
                    sender.sendMessage("Usage: /authme unregister playername");
                    return true;
                }
                String name = args[1].toLowerCase();
                PlayerCache.getInstance().removePlayer(name);
                this.database.removeAuth(name);
                sender.sendMessage("unregistered");
                ConsoleLogger.info(args[1] + " unregistered");
            } else {
                sender.sendMessage("Usage: /authme reload|register playername password|changepassword playername password|unregister playername");
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            return true;
        }
        if (!sender.hasPermission("authme." + label.toLowerCase())) {
            sender.sendMessage(this.m._("no_perm"));
            return true;
        }
        Player player = (Player)sender;
        String name = player.getName().toLowerCase();
        String ip = player.getAddress().getAddress().getHostAddress();
        if (label.equalsIgnoreCase("register")) {
            if (PlayerCache.getInstance().isAuthenticated(name)) {
                player.sendMessage(this.m._("logged_in"));
                return true;
            }
            if (!this.settings.isRegistrationEnabled()) {
                player.sendMessage(this.m._("reg_disabled"));
                return true;
            }
            if (args.length == 0) {
                player.sendMessage(this.m._("usage_reg"));
                return true;
            }
            if (this.database.isAuthAvailable(player.getName().toLowerCase())) {
                player.sendMessage(this.m._("user_regged"));
                return true;
            }
            String hash = this.pws.getHash(args[0]);
            PlayerAuth auth = new PlayerAuth(name, hash, ip);
            this.database.saveAuth(auth);
            PlayerCache.getInstance().addPlayer(auth);
            LimboPlayer limbo = LimboCache.getInstance().getLimboPlayer(name);
            if (limbo != null) {
                player.getInventory().setContents(limbo.getInventory());
                player.getInventory().setArmorContents(limbo.getArmour());
                this.getServer().getScheduler().cancelTask(limbo.getTimeoutTaskId());
                LimboCache.getInstance().deleteLimboPlayer(name);
            }
            player.sendMessage(this.m._("registered"));
            ConsoleLogger.info(player.getDisplayName() + " registered");
            return true;
        }
        if (label.equalsIgnoreCase("login")) {
            if (PlayerCache.getInstance().isAuthenticated(name)) {
                player.sendMessage(this.m._("logged_in"));
                return true;
            }
            if (args.length == 0) {
                player.sendMessage(this.m._("usage_log"));
                return true;
            }
            if (!this.database.isAuthAvailable(player.getName().toLowerCase())) {
                player.sendMessage(this.m._("user_unknown"));
                return true;
            }
            String hash = this.database.getAuth(name).getHash();
            System.out.println(hash);
            if (this.pws.comparePasswordWithHash(args[0], hash)) {
                PlayerAuth auth = new PlayerAuth(name, hash, ip);
                this.database.updateIP(auth);
                PlayerCache.getInstance().addPlayer(auth);
                LimboPlayer limbo = LimboCache.getInstance().getLimboPlayer(name);
                if (limbo != null) {
                    player.getInventory().setContents(limbo.getInventory());
                    player.getInventory().setArmorContents(limbo.getArmour());
                    if (this.settings.isTeleportToSpawnEnabled()) {
                        player.teleport(limbo.getLoc());
                    }
                    this.getServer().getScheduler().cancelTask(limbo.getTimeoutTaskId());
                    LimboCache.getInstance().deleteLimboPlayer(name);
                }
                player.sendMessage(this.m._("login"));
                ConsoleLogger.info(player.getDisplayName() + " logged in!");
            } else {
                ConsoleLogger.info(player.getDisplayName() + " used the wrong password");
                if (this.settings.isKickOnWrongPasswordEnabled()) {
                    player.kickPlayer(this.m._("wrong_pwd"));
                } else {
                    player.sendMessage(this.m._("wrong_pwd"));
                }
            }
            return true;
        }
        if (label.equalsIgnoreCase("changepassword")) {
            if (!PlayerCache.getInstance().isAuthenticated(name)) {
                player.sendMessage(this.m._("not_logged_in"));
                return true;
            }
            if (args.length != 2) {
                player.sendMessage(this.m._("Usage: /changepassword oldPassword newPassword"));
                return true;
            }
            String hashnew = this.pws.getHash(args[1]);
            if (this.pws.comparePasswordWithHash(args[0], PlayerCache.getInstance().getAuth(name).getHash())) {
                PlayerAuth auth = new PlayerAuth(name, hashnew, ip);
                this.database.updatePassword(auth);
                PlayerCache.getInstance().updatePlayer(auth);
                player.sendMessage(this.m._("pwd_changed"));
                ConsoleLogger.info(player.getDisplayName() + " changed his password");
            } else {
                player.sendMessage(this.m._("wrong_pwd"));
            }
            return true;
        }
        if (label.equalsIgnoreCase("logout")) {
            if (!PlayerCache.getInstance().isAuthenticated(name)) {
                player.sendMessage(this.m._("not_logged_in"));
                return true;
            }
            PlayerCache.getInstance().removePlayer(player.getName().toLowerCase());
            LimboCache.getInstance().addLimboPlayer(player);
            player.getInventory().setArmorContents(new ItemStack[0]);
            player.getInventory().setContents(new ItemStack[36]);
            int delay = this.settings.getRegistrationTimeout() * 20;
            int interval = this.settings.getWarnMessageInterval();
            BukkitScheduler sched = this.getServer().getScheduler();
            if (delay != 0) {
                int id = sched.scheduleSyncDelayedTask((Plugin)this, (Runnable)new TimeoutTask(this, name), (long)delay);
                LimboCache.getInstance().getLimboPlayer(name).setTimeoutTaskId(id);
            }
            sched.scheduleSyncDelayedTask((Plugin)this, (Runnable)new MessageTask(this, name, this.m._("login_msg"), interval));
            player.sendMessage(this.m._("logout"));
            ConsoleLogger.info(player.getDisplayName() + " logged out");
            return true;
        }
        if (label.equalsIgnoreCase("unregister")) {
            if (!PlayerCache.getInstance().isAuthenticated(name)) {
                player.sendMessage(this.m._("not_logged_in"));
                return true;
            }
            if (args.length != 1) {
                player.sendMessage(this.m._("usage_unreg"));
                return true;
            }
            if (this.pws.comparePasswordWithHash(args[0], PlayerCache.getInstance().getAuth(name).getHash())) {
                PlayerCache.getInstance().removePlayer(player.getName().toLowerCase());
                LimboCache.getInstance().addLimboPlayer(player);
                player.getInventory().setArmorContents(new ItemStack[0]);
                player.getInventory().setContents(new ItemStack[36]);
                this.database.removeAuth(name);
                int delay = this.settings.getRegistrationTimeout() * 20;
                int interval = this.settings.getWarnMessageInterval();
                BukkitScheduler sched = this.getServer().getScheduler();
                if (delay != 0) {
                    int id = sched.scheduleSyncDelayedTask((Plugin)this, (Runnable)new TimeoutTask(this, name), (long)delay);
                    LimboCache.getInstance().getLimboPlayer(name).setTimeoutTaskId(id);
                }
                sched.scheduleSyncDelayedTask((Plugin)this, (Runnable)new MessageTask(this, name, this.m._("reg_msg"), interval));
                player.sendMessage("unregistered");
                ConsoleLogger.info(player.getDisplayName() + " unregistered himself");
            } else {
                player.sendMessage(this.m._("wrong_pwd"));
            }
            return true;
        }
        return false;
    }
}

