/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.worldgen.BiomeFilter;
import com.simibubi.create.foundation.worldgen.ConfigDrivenDecorator;
import com.simibubi.create.foundation.worldgen.ConfigDrivenOreConfiguration;
import com.simibubi.create.foundation.worldgen.LayerPattern;
import com.simibubi.create.foundation.worldgen.LayeredOreFeature;
import com.simibubi.create.foundation.worldgen.VanillaStyleOreFeature;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigDrivenFeatureEntry
extends ConfigBase {
    public final String id;
    public BiomeFilter biomeFilter;
    private NonNullSupplier<? extends Block> block;
    private NonNullSupplier<? extends Block> deepblock;
    private NonNullSupplier<? extends Block> netherblock;
    private List<NonNullSupplier<LayerPattern>> layers = new ArrayList<NonNullSupplier<LayerPattern>>();
    protected ConfigBase.ConfigInt clusterSize;
    protected ConfigBase.ConfigInt minHeight;
    protected ConfigBase.ConfigInt maxHeight;
    protected ConfigBase.ConfigFloat frequency;
    Function<ConfigDrivenFeatureEntry, ? extends ConfiguredFeature<?, ?>> factory;
    Optional<Pair<ConfiguredFeature<?, ?>, PlacedFeature>> feature = Optional.empty();

    public ConfigDrivenFeatureEntry(String id, int clusterSize, float frequency) {
        this.id = id;
        this.factory = this::standardFactory;
        this.clusterSize = this.i(clusterSize, 0, "clusterSize", new String[0]);
        this.minHeight = this.i(0, 0, "minHeight", new String[0]);
        this.maxHeight = this.i(256, 0, "maxHeight", new String[0]);
        this.frequency = this.f(frequency, 0.0f, 512.0f, "frequency", "Amount of clusters generated per Chunk.", "  >1 to spawn multiple.", "  <1 to make it a chance.", "  0 to disable.");
    }

    public ConfigDrivenFeatureEntry withLayerPattern(NonNullSupplier<LayerPattern> pattern) {
        this.layers.add(pattern);
        this.factory = this::layersFactory;
        return this;
    }

    public ConfigDrivenFeatureEntry withBlock(NonNullSupplier<? extends Block> block) {
        this.deepblock = block;
        this.block = this.deepblock;
        return this;
    }

    public ConfigDrivenFeatureEntry withNetherBlock(NonNullSupplier<? extends Block> block) {
        this.netherblock = block;
        return this;
    }

    public ConfigDrivenFeatureEntry withBlocks(Couple<NonNullSupplier<? extends Block>> blocks) {
        this.block = (NonNullSupplier)blocks.getFirst();
        this.deepblock = (NonNullSupplier)blocks.getSecond();
        return this;
    }

    public ConfigDrivenFeatureEntry between(int minHeight, int maxHeight) {
        this.allValues.remove(this.minHeight);
        this.allValues.remove(this.maxHeight);
        this.minHeight = this.i(minHeight, -64, "minHeight", new String[0]);
        this.maxHeight = this.i(maxHeight, -64, "maxHeight", new String[0]);
        return this;
    }

    public Pair<ConfiguredFeature<?, ?>, PlacedFeature> getFeature() {
        if (!this.feature.isPresent()) {
            ConfiguredFeature<?, ?> configured = this.factory.apply(this);
            this.feature = Optional.of(Pair.of(configured, configured.m_190823_(new PlacementModifier[]{new ConfigDrivenDecorator(this.id)})));
        }
        return this.feature.get();
    }

    private ConfiguredFeature<?, ?> layersFactory(ConfigDrivenFeatureEntry entry) {
        ConfigDrivenOreConfiguration config = new ConfigDrivenOreConfiguration((List<OreConfiguration.TargetBlockState>)ImmutableList.of(), 0.0f, this.id);
        LayeredOreFeature.LAYER_PATTERNS.put(Create.asResource(this.id), this.layers.stream().map(NonNullSupplier::get).toList());
        return LayeredOreFeature.INSTANCE.m_65815_(config);
    }

    private ConfiguredFeature<?, ?> standardFactory(ConfigDrivenFeatureEntry entry) {
        ConfigDrivenOreConfiguration config = new ConfigDrivenOreConfiguration(this.createTarget(), 0.0f, this.id);
        return VanillaStyleOreFeature.INSTANCE.m_65815_(config);
    }

    private List<OreConfiguration.TargetBlockState> createTarget() {
        ArrayList<OreConfiguration.TargetBlockState> list = new ArrayList<OreConfiguration.TargetBlockState>();
        if (this.block != null) {
            list.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)this.block.get().m_49966_()));
        }
        if (this.deepblock != null) {
            list.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)this.deepblock.get().m_49966_()));
        }
        if (this.netherblock != null) {
            list.add(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)this.netherblock.get().m_49966_()));
        }
        return list;
    }

    public void addToConfig(ForgeConfigSpec.Builder builder) {
        this.registerAll(builder);
    }

    @Override
    public String getName() {
        return this.id;
    }
}

