/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.outliner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.render.RenderTypes;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.outliner.Outline;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class BlockClusterOutline
extends Outline {
    private Cluster cluster = new Cluster();

    public BlockClusterOutline(Iterable<BlockPos> selection) {
        selection.forEach(this.cluster::include);
    }

    @Override
    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, float pt) {
        this.cluster.visibleEdges.forEach(edge -> {
            Vec3 start = Vec3.m_82528_((Vec3i)edge.pos);
            Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)edge.axis);
            this.renderAACuboidLine(ms, buffer, start, Vec3.m_82528_((Vec3i)edge.pos.m_142300_(direction)));
        });
        Optional<AllSpecialTextures> faceTexture = this.params.faceTexture;
        if (!faceTexture.isPresent()) {
            return;
        }
        RenderType translucentType = RenderTypes.getOutlineTranslucent(faceTexture.get().getLocation(), true);
        VertexConsumer builder = buffer.getLateBuffer(translucentType);
        this.cluster.visibleFaces.forEach((face, axisDirection) -> {
            Direction direction = Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)face.axis);
            BlockPos pos = face.pos;
            if (axisDirection == Direction.AxisDirection.POSITIVE) {
                pos = pos.m_142300_(direction.m_122424_());
            }
            this.renderBlockFace(ms, builder, pos, direction);
        });
    }

    protected void renderBlockFace(PoseStack ms, VertexConsumer builder, BlockPos pos, Direction face) {
        Vec3 center = VecHelper.getCenterOf((Vec3i)pos);
        Vec3 offset = Vec3.m_82528_((Vec3i)face.m_122436_());
        Vec3 plane = VecHelper.axisAlingedPlaneOf(offset);
        Direction.Axis axis = face.m_122434_();
        offset = offset.m_82490_(0.5078125);
        plane = plane.m_82490_(0.5).m_82549_(offset);
        int deg = face.m_122421_().m_122540_() * 90;
        Vec3 a1 = plane.m_82549_(center);
        plane = VecHelper.rotate(plane, deg, axis);
        Vec3 a2 = plane.m_82549_(center);
        plane = VecHelper.rotate(plane, deg, axis);
        Vec3 a3 = plane.m_82549_(center);
        plane = VecHelper.rotate(plane, deg, axis);
        Vec3 a4 = plane.m_82549_(center);
        this.putQuad(ms, builder, a1, a2, a3, a4, face);
    }

    private static class Cluster {
        private Map<MergeEntry, Direction.AxisDirection> visibleFaces;
        private Set<MergeEntry> visibleEdges = new HashSet<MergeEntry>();

        public Cluster() {
            this.visibleFaces = new HashMap<MergeEntry, Direction.AxisDirection>();
        }

        public void include(BlockPos pos) {
            for (Direction.Axis axis : Iterate.axes) {
                Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
                int[] nArray = Iterate.zeroAndOne;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int offset = nArray[i];
                    MergeEntry entry = new MergeEntry(axis, pos.m_5484_(direction, offset));
                    if (this.visibleFaces.remove(entry) != null) continue;
                    this.visibleFaces.put(entry, offset == 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
                }
            }
            block2: for (Direction.Axis axis : Iterate.axes) {
                for (Direction.Axis axis2 : Iterate.axes) {
                    if (axis == axis2) continue;
                    for (Direction.Axis axis3 : Iterate.axes) {
                        if (axis == axis3 || axis2 == axis3) continue;
                        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis2);
                        Direction direction2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis3);
                        for (int offset : Iterate.zeroAndOne) {
                            BlockPos entryPos = pos.m_5484_(direction, offset);
                            for (int offset2 : Iterate.zeroAndOne) {
                                MergeEntry entry = new MergeEntry(axis, entryPos = entryPos.m_5484_(direction2, offset2));
                                if (this.visibleEdges.remove(entry)) continue;
                                this.visibleEdges.add(entry);
                            }
                        }
                    }
                    continue block2;
                }
            }
        }
    }

    private static class MergeEntry {
        private Direction.Axis axis;
        private BlockPos pos;

        public MergeEntry(Direction.Axis axis, BlockPos pos) {
            this.axis = axis;
            this.pos = pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MergeEntry)) {
                return false;
            }
            MergeEntry other = (MergeEntry)o;
            return this.axis == other.axis && this.pos.equals((Object)other.pos);
        }

        public int hashCode() {
            return this.pos.hashCode() * 31 + this.axis.ordinal();
        }
    }
}

