/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.animation;

import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;

public class LerpedFloat {
    protected Interpolater interpolater;
    protected float previousValue;
    protected float value;
    protected Chaser chaseFunction;
    protected float chaseTarget;
    protected float chaseSpeed;
    protected boolean forcedSync;

    public LerpedFloat(Interpolater interpolater) {
        this.interpolater = interpolater;
        this.startWithValue(0.0);
        this.forcedSync = true;
    }

    public static LerpedFloat linear() {
        return new LerpedFloat((p, c, t) -> (float)Mth.m_14139_((double)p, (double)c, (double)t));
    }

    public static LerpedFloat angular() {
        return new LerpedFloat(AngleHelper::angleLerp);
    }

    public LerpedFloat startWithValue(double value) {
        float f;
        this.previousValue = f = (float)value;
        this.chaseTarget = f;
        this.value = f;
        return this;
    }

    public LerpedFloat chase(double value, double speed, Chaser chaseFunction) {
        this.chaseTarget = (float)value;
        this.chaseSpeed = (float)speed;
        this.chaseFunction = chaseFunction;
        return this;
    }

    public void updateChaseTarget(float target) {
        this.chaseTarget = target;
    }

    public boolean updateChaseSpeed(double speed) {
        float prevSpeed = this.chaseSpeed;
        this.chaseSpeed = (float)speed;
        return !Mth.m_14082_((double)prevSpeed, (double)speed);
    }

    public void tickChaser() {
        this.previousValue = this.value;
        if (this.chaseFunction == null) {
            return;
        }
        if (Mth.m_14082_((double)this.value, (double)this.chaseTarget)) {
            this.value = this.chaseTarget;
            return;
        }
        this.value = this.chaseFunction.chase(this.value, this.chaseSpeed, this.chaseTarget);
    }

    public void setValue(double value) {
        this.previousValue = this.value;
        this.value = (float)value;
    }

    public float getValue() {
        return this.getValue(1.0f);
    }

    public float getValue(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.previousValue, (float)this.value);
    }

    public boolean settled() {
        return Mth.m_14082_((double)this.previousValue, (double)this.value);
    }

    public float getChaseTarget() {
        return this.chaseTarget;
    }

    public void forceNextSync() {
        this.forcedSync = true;
    }

    public CompoundTag writeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128350_("Speed", this.chaseSpeed);
        compoundNBT.m_128350_("Target", this.chaseTarget);
        compoundNBT.m_128350_("Value", this.value);
        if (this.forcedSync) {
            compoundNBT.m_128379_("Force", true);
        }
        this.forcedSync = false;
        return compoundNBT;
    }

    public void readNBT(CompoundTag compoundNBT, boolean clientPacket) {
        if (!clientPacket || compoundNBT.m_128441_("Force")) {
            this.startWithValue(compoundNBT.m_128457_("Value"));
        }
        this.readChaser(compoundNBT);
    }

    protected void readChaser(CompoundTag compoundNBT) {
        this.chaseSpeed = compoundNBT.m_128457_("Speed");
        this.chaseTarget = compoundNBT.m_128457_("Target");
    }

    @FunctionalInterface
    public static interface Interpolater {
        public float interpolate(double var1, double var3, double var5);
    }

    @FunctionalInterface
    public static interface Chaser {
        public static final Chaser IDLE = (c, s, t) -> (float)c;
        public static final Chaser EXP = Chaser.exp(Double.MAX_VALUE);
        public static final Chaser LINEAR = (c, s, t) -> (float)(c + Mth.m_14008_((double)(t - c), (double)(-s), (double)s));

        public static Chaser exp(double maxEffectiveSpeed) {
            return (c, s, t) -> (float)(c + Mth.m_14008_((double)((t - c) * s), (double)(-maxEffectiveSpeed), (double)maxEffectiveSpeed));
        }

        public float chase(double var1, double var3, double var5);
    }
}

