/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.connected;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.foundation.block.connected.BakedModelWrapperWithData;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.block.render.QuadHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class CTModel
extends BakedModelWrapperWithData {
    protected static final ModelProperty<CTData> CT_PROPERTY = new ModelProperty();
    private ConnectedTextureBehaviour behaviour;

    public CTModel(BakedModel originalModel, ConnectedTextureBehaviour behaviour) {
        super(originalModel);
        this.behaviour = behaviour;
    }

    @Override
    protected ModelDataMap.Builder gatherModelData(ModelDataMap.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state) {
        return builder.withInitial(CT_PROPERTY, (Object)this.createCTData(world, pos, state));
    }

    protected CTData createCTData(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        CTData data = new CTData();
        for (Direction face : Iterate.directions) {
            CTSpriteShiftEntry spriteShift;
            if (!Block.m_152444_((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)pos.m_142300_(face)) && !this.behaviour.buildContextForOccludedDirections() || (spriteShift = this.behaviour.get(state, face)) == null) continue;
            ConnectedTextureBehaviour.CTContext ctContext = this.behaviour.buildContext(world, pos, state, face);
            data.put(face, spriteShift.getTextureIndex(ctContext));
        }
        return data;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData);
        if (!extraData.hasProperty(CT_PROPERTY)) {
            return quads;
        }
        CTData data = (CTData)extraData.getData(CT_PROPERTY);
        quads = new ArrayList<BakedQuad>(quads);
        VertexFormat format = DefaultVertexFormat.f_85811_;
        for (int i = 0; i < quads.size(); ++i) {
            int index;
            BakedQuad quad = (BakedQuad)quads.get(i);
            CTSpriteShiftEntry spriteShift = this.behaviour.get(state, quad.m_111306_());
            if (spriteShift == null || quad.m_173410_() != spriteShift.getOriginal() || (index = data.get(quad.m_111306_())) == -1) continue;
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.m_111303_();
            for (int vertex = 0; vertex < vertexData.length; vertex += format.m_86017_()) {
                int uvOffset = 4;
                int uIndex = vertex + uvOffset;
                int vIndex = vertex + uvOffset + 1;
                float u = Float.intBitsToFloat(vertexData[uIndex]);
                float v = Float.intBitsToFloat(vertexData[vIndex]);
                vertexData[uIndex] = Float.floatToRawIntBits(spriteShift.getTargetU(u, index));
                vertexData[vIndex] = Float.floatToRawIntBits(spriteShift.getTargetV(v, index));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }

    private class CTData {
        int[] indices = new int[6];

        public CTData() {
            Arrays.fill(this.indices, -1);
        }

        void put(Direction face, int texture) {
            this.indices[face.m_122411_()] = texture;
        }

        int get(Direction face) {
            return this.indices[face.m_122411_()];
        }
    }
}

