/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.item.LecternControllerBlock;
import com.simibubi.create.content.logistics.item.LinkedControllerBindPacket;
import com.simibubi.create.content.logistics.item.LinkedControllerInputPacket;
import com.simibubi.create.content.logistics.item.LinkedControllerItemRenderer;
import com.simibubi.create.content.logistics.item.LinkedControllerStopLecternPacket;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Vector;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

public class LinkedControllerClientHandler {
    public static final IIngameOverlay OVERLAY = LinkedControllerClientHandler::renderOverlay;
    public static Mode MODE = Mode.IDLE;
    public static int PACKET_RATE = 5;
    public static Collection<Integer> currentlyPressed = new HashSet<Integer>();
    private static BlockPos lecternPos;
    private static BlockPos selectedLocation;
    private static Vector<KeyMapping> controls;
    private static int packetCooldown;

    public static Vector<KeyMapping> getControls() {
        if (controls == null) {
            Options gameSettings = Minecraft.m_91087_().f_91066_;
            controls = new Vector(6);
            controls.add(gameSettings.f_92085_);
            controls.add(gameSettings.f_92087_);
            controls.add(gameSettings.f_92086_);
            controls.add(gameSettings.f_92088_);
            controls.add(gameSettings.f_92089_);
            controls.add(gameSettings.f_92090_);
        }
        return controls;
    }

    public static void toggleBindMode(BlockPos location) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.BIND;
            selectedLocation = location;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
        }
    }

    public static void toggle() {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = null;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
        }
    }

    public static void activateInLectern(BlockPos lecternAt) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = lecternAt;
        }
    }

    public static void deactivateInLectern() {
        if (MODE == Mode.ACTIVE && LinkedControllerClientHandler.inLectern()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
        }
    }

    public static boolean inLectern() {
        return lecternPos != null;
    }

    protected static void onReset() {
        LinkedControllerClientHandler.getControls().forEach(kb -> kb.m_7249_(LinkedControllerClientHandler.isActuallyPressed(kb)));
        packetCooldown = 0;
        selectedLocation = BlockPos.f_121853_;
        if (LinkedControllerClientHandler.inLectern()) {
            AllPackets.channel.sendToServer((Object)new LinkedControllerStopLecternPacket(lecternPos));
        }
        lecternPos = null;
        if (!currentlyPressed.isEmpty()) {
            AllPackets.channel.sendToServer((Object)new LinkedControllerInputPacket(currentlyPressed, false));
        }
        currentlyPressed.clear();
        LinkedControllerItemRenderer.resetButtons();
    }

    protected static boolean isActuallyPressed(KeyMapping kb) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)kb.getKey().m_84873_());
    }

    public static void tick() {
        LinkedControllerItemRenderer.tick();
        if (MODE == Mode.IDLE) {
            return;
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ItemStack heldItem = player.m_21205_();
        if (player.m_5833_()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        if (!(LinkedControllerClientHandler.inLectern() || AllItems.LINKED_CONTROLLER.isIn(heldItem) || AllItems.LINKED_CONTROLLER.isIn(heldItem = player.m_21206_()))) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        if (LinkedControllerClientHandler.inLectern() && ((LecternControllerBlock)AllBlocks.LECTERN_CONTROLLER.get()).getTileEntityOptional((BlockGetter)mc.f_91073_, lecternPos).map(te -> !te.isUsedBy((Player)mc.f_91074_)).orElse(true).booleanValue()) {
            LinkedControllerClientHandler.deactivateInLectern();
            return;
        }
        if (mc.f_91080_ != null) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        if (InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)256)) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset();
            return;
        }
        Vector<KeyMapping> controls = LinkedControllerClientHandler.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!LinkedControllerClientHandler.isActuallyPressed(controls.get(i))) continue;
            pressedKeys.add(i);
        }
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (MODE == Mode.ACTIVE) {
            if (!releasedKeys.isEmpty()) {
                AllPackets.channel.sendToServer((Object)new LinkedControllerInputPacket(releasedKeys, false, lecternPos));
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 0.5f, true);
            }
            if (!newKeys.isEmpty()) {
                AllPackets.channel.sendToServer((Object)new LinkedControllerInputPacket(newKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.f_19853_, (Vec3i)player.m_142538_(), 1.0f, 0.75f, true);
            }
            if (packetCooldown == 0 && !pressedKeys.isEmpty()) {
                AllPackets.channel.sendToServer((Object)new LinkedControllerInputPacket(pressedKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
            }
        }
        if (MODE == Mode.BIND) {
            Iterator iterator;
            VoxelShape shape = mc.f_91073_.m_8055_(selectedLocation).m_60808_((BlockGetter)mc.f_91073_, selectedLocation);
            if (!shape.m_83281_()) {
                CreateClient.OUTLINER.showAABB("controller", shape.m_83215_().m_82338_(selectedLocation)).colored(12008493).lineWidth(0.0625f);
            }
            if ((iterator = newKeys.iterator()).hasNext()) {
                Integer integer = (Integer)iterator.next();
                LinkBehaviour linkBehaviour = TileEntityBehaviour.get((BlockGetter)mc.f_91073_, selectedLocation, LinkBehaviour.TYPE);
                if (linkBehaviour != null) {
                    AllPackets.channel.sendToServer((Object)new LinkedControllerBindPacket(integer, selectedLocation));
                    Lang.sendStatus((Player)mc.f_91074_, "linked_controller.key_bound", controls.get(integer).m_90863_().getString());
                }
                MODE = Mode.IDLE;
            }
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.m_7249_(false));
    }

    public static void renderOverlay(ForgeIngameGui gui, PoseStack poseStack, float partialTicks, int width1, int height1) {
        if (MODE != Mode.BIND) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_85836_();
        Screen tooltipScreen = new Screen(TextComponent.f_131282_){};
        tooltipScreen.m_6575_(mc, width1, height1);
        Object[] keys = new Object[6];
        Vector<KeyMapping> controls = LinkedControllerClientHandler.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            KeyMapping keyBinding = controls.get(i);
            keys[i] = keyBinding.m_90863_().getString();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Lang.createTranslationTextComponent("linked_controller.bind_mode", new Object[0]).m_130940_(ChatFormatting.GOLD));
        list.addAll(TooltipHelper.cutTextComponent((Component)Lang.createTranslationTextComponent("linked_controller.press_keybind", keys), ChatFormatting.GRAY, ChatFormatting.GRAY));
        int width = 0;
        int n = list.size();
        Objects.requireNonNull(mc.f_91062_);
        int height = n * 9;
        for (Component component : list) {
            width = Math.max(width, mc.f_91062_.m_92852_((FormattedText)component));
        }
        int x = width1 / 3 - width / 2;
        int n2 = height1 - height;
        tooltipScreen.m_96597_(poseStack, list, x, n2);
        poseStack.m_85849_();
    }

    static {
        selectedLocation = BlockPos.f_121853_;
    }

    public static enum Mode {
        IDLE,
        ACTIVE,
        BIND;

    }
}

