/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.content.logistics.block.redstone.ContentObserverTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class ContentObserverBlock
extends HorizontalDirectionalBlock
implements ITE<ContentObserverTileEntity>,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public ContentObserverBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.CONTENT_OBSERVER.get((Direction)state.m_61143_((Property)f_54117_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, f_54117_});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Capability itemCap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        Capability fluidCap = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        Direction preferredFacing = null;
        for (Direction face : Iterate.horizontalDirections) {
            BlockPos offsetPos = context.m_8083_().m_142300_(face);
            Level world = context.m_43725_();
            boolean canDetect = false;
            BlockEntity tileEntity = world.m_7702_(offsetPos);
            if (TileEntityBehaviour.get(tileEntity, TransportedItemStackHandlerBehaviour.TYPE) != null) {
                canDetect = true;
            } else if (TileEntityBehaviour.get(tileEntity, FluidTransportBehaviour.TYPE) != null) {
                canDetect = true;
            } else if (tileEntity != null && (tileEntity.getCapability(itemCap).isPresent() || tileEntity.getCapability(fluidCap).isPresent())) {
                canDetect = true;
            } else if (tileEntity instanceof FunnelTileEntity) {
                canDetect = true;
            }
            if (!canDetect) continue;
            if (preferredFacing != null) {
                preferredFacing = null;
                break;
            }
            preferredFacing = face;
        }
        if (preferredFacing != null) {
            return (BlockState)state.m_61124_((Property)f_54117_, preferredFacing);
        }
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.m_7899_(blockState) && (side == null || side != ((Direction)blockState.m_61143_((Property)f_54117_)).m_122424_()) ? 15 : 0;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        worldIn.m_46672_(pos, (Block)this);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_155947_() && state.m_60734_() != newState.m_60734_()) {
            TileEntityBehaviour.destroy((BlockGetter)worldIn, pos, FilteringBehaviour.TYPE);
            worldIn.m_46747_(pos);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        InvManipulationBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.onNeighborChanged(fromPos);
        }
    }

    public void onFunnelTransfer(Level world, BlockPos funnelPos, ItemStack transferred) {
        for (Direction direction : Iterate.horizontalDirections) {
            BlockPos detectorPos = funnelPos.m_142300_(direction);
            BlockState detectorState = world.m_8055_(detectorPos);
            if (!AllBlocks.CONTENT_OBSERVER.has(detectorState) || detectorState.m_61143_((Property)f_54117_) != direction.m_122424_()) continue;
            this.withTileEntityDo((BlockGetter)world, detectorPos, te -> {
                FilteringBehaviour filteringBehaviour = TileEntityBehaviour.get(te, FilteringBehaviour.TYPE);
                if (filteringBehaviour == null) {
                    return;
                }
                if (!filteringBehaviour.test(transferred)) {
                    return;
                }
                te.activate(4);
            });
        }
    }

    @Override
    public Class<ContentObserverTileEntity> getTileEntityClass() {
        return ContentObserverTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends ContentObserverTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.CONTENT_OBSERVER.get();
    }
}

