/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.depot.EjectorBlock;
import com.simibubi.create.content.logistics.block.depot.EjectorTileEntity;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class EjectorPlacementPacket
extends SimplePacketBase {
    private int h;
    private int v;
    private BlockPos pos;
    private Direction facing;

    public EjectorPlacementPacket(int h, int v, BlockPos pos, Direction facing) {
        this.h = h;
        this.v = v;
        this.pos = pos;
        this.facing = facing;
    }

    public EjectorPlacementPacket(FriendlyByteBuf buffer) {
        this.h = buffer.readInt();
        this.v = buffer.readInt();
        this.pos = buffer.m_130135_();
        this.facing = Direction.m_122376_((int)buffer.m_130242_());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.h);
        buffer.writeInt(this.v);
        buffer.m_130064_(this.pos);
        buffer.m_130130_(this.facing.m_122411_());
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.f_19853_;
            if (world == null || !world.m_46749_(this.pos)) {
                return;
            }
            BlockEntity tileEntity = world.m_7702_(this.pos);
            BlockState state = world.m_8055_(this.pos);
            if (tileEntity instanceof EjectorTileEntity) {
                ((EjectorTileEntity)tileEntity).setTarget(this.h, this.v);
            }
            if (AllBlocks.WEIGHTED_EJECTOR.has(state)) {
                world.m_46597_(this.pos, (BlockState)state.m_61124_(EjectorBlock.HORIZONTAL_FACING, (Comparable)this.facing));
            }
        });
        context.get().setPacketHandled(true);
    }
}

