/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.gearbox;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GearboxRenderer
extends KineticTileEntityRenderer {
    public GearboxRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(KineticTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        Direction.Axis boxAxis = (Direction.Axis)te.m_58900_().m_61143_((Property)BlockStateProperties.f_61365_);
        BlockPos pos = te.m_58899_();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)te.m_58904_());
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.m_122434_();
            if (boxAxis == axis) continue;
            SuperByteBuffer shaft = CachedBufferer.partialFacing(AllBlockPartials.SHAFT_HALF, te.m_58900_(), direction);
            float offset = GearboxRenderer.getRotationOffsetForPosition(te, pos, axis);
            float angle = time * te.getSpeed() * 3.0f / 10.0f % 360.0f;
            if (te.getSpeed() != 0.0f && te.hasSource()) {
                BlockPos source = te.source.m_141950_((Vec3i)te.m_58899_());
                Direction sourceFacing = Direction.m_122372_((float)source.m_123341_(), (float)source.m_123342_(), (float)source.m_123343_());
                if (sourceFacing.m_122434_() == direction.m_122434_()) {
                    angle *= sourceFacing == direction ? 1.0f : -1.0f;
                } else if (sourceFacing.m_122421_() == direction.m_122421_()) {
                    angle *= -1.0f;
                }
            }
            angle += offset;
            angle = angle / 180.0f * (float)Math.PI;
            GearboxRenderer.kineticRotationTransform(shaft, te, axis, angle, light);
            shaft.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
    }
}

