/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.elementary;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CogwheelBlockItem
extends BlockItem {
    boolean large;
    private final int placementHelperId;
    private final int integratedCogHelperId;

    public CogwheelBlockItem(CogWheelBlock block, Item.Properties builder) {
        super((Block)block, builder);
        this.large = block.isLarge;
        this.placementHelperId = PlacementHelpers.register(this.large ? new LargeCogHelper() : new SmallCogHelper());
        this.integratedCogHelperId = PlacementHelpers.register(this.large ? new IntegratedLargeCogHelper() : new IntegratedSmallCogHelper());
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = world.m_8055_(pos);
        IPlacementHelper helper = PlacementHelpers.get(this.placementHelperId);
        Player player = context.m_43723_();
        BlockHitResult ray = new BlockHitResult(context.m_43720_(), context.m_43719_(), pos, true);
        if (helper.matchesState(state) && player != null && !player.m_6144_()) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, this, player, context.m_43724_(), ray);
        }
        if (this.integratedCogHelperId != -1 && (helper = PlacementHelpers.get(this.integratedCogHelperId)).matchesState(state) && player != null && !player.m_6144_()) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, this, player, context.m_43724_(), ray);
        }
        return super.onItemUseFirst(stack, context);
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        this.triggerShiftingGearsAdvancement(context.m_43725_(), context.m_8083_(), state, context.m_43723_());
        return super.m_7429_(context, state);
    }

    protected void triggerShiftingGearsAdvancement(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.f_46443_ || player == null) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)CogWheelBlock.AXIS);
        for (Direction.Axis perpendicular1 : Iterate.axes) {
            if (perpendicular1 == axis) continue;
            Direction d1 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular1);
            for (Direction.Axis perpendicular2 : Iterate.axes) {
                if (perpendicular1 == perpendicular2 || axis == perpendicular2) continue;
                Direction d2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)perpendicular2);
                for (int offset1 : Iterate.positiveAndNegative) {
                    for (int offset2 : Iterate.positiveAndNegative) {
                        BlockPos connectedPos = pos.m_5484_(d1, offset1).m_5484_(d2, offset2);
                        BlockState blockState = world.m_8055_(connectedPos);
                        if (!(blockState.m_60734_() instanceof CogWheelBlock) || blockState.m_61143_((Property)CogWheelBlock.AXIS) != axis || ICogWheel.isLargeCog(blockState) == this.large) continue;
                        AllTriggers.triggerFor(AllTriggers.SHIFTING_GEARS, player);
                    }
                }
            }
        }
    }

    @MethodsReturnNonnullByDefault
    private static class LargeCogHelper
    extends DiagonalCogHelper {
        private LargeCogHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (ICogWheel.isLargeCog(state)) {
                Direction.Axis axis = ((IRotate)state.m_60734_()).getRotationAxis(state);
                Direction side = IPlacementHelper.orderedByDistanceOnlyAxis(pos, ray.m_82450_(), axis).get(0);
                List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.m_82450_(), axis);
                for (Direction dir : directions) {
                    BlockPos newPos = pos.m_142300_(dir).m_142300_(side);
                    if (!CogWheelBlock.isValidCogwheelPosition(true, (LevelReader)world, newPos, dir.m_122434_()) || !world.m_8055_(newPos).m_60767_().m_76336_()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.m_61124_(RotatedPillarKineticBlock.AXIS, (Comparable)dir.m_122434_()));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class SmallCogHelper
    extends DiagonalCogHelper {
        private SmallCogHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            if (this.hitOnShaft(state, ray)) {
                return PlacementOffset.fail();
            }
            if (!ICogWheel.isLargeCog(state)) {
                Direction.Axis axis = ((IRotate)state.m_60734_()).getRotationAxis(state);
                List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.m_82450_(), axis);
                for (Direction dir : directions) {
                    BlockPos newPos = pos.m_142300_(dir);
                    if (!CogWheelBlock.isValidCogwheelPosition(false, (LevelReader)world, newPos, axis) || !world.m_8055_(newPos).m_60767_().m_76336_()) continue;
                    return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.m_61124_(RotatedPillarKineticBlock.AXIS, (Comparable)axis));
                }
                return PlacementOffset.fail();
            }
            return super.getOffset(player, world, state, pos, ray);
        }
    }

    @MethodsReturnNonnullByDefault
    public static class IntegratedLargeCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel(s.m_60734_()) && ICogWheel.isSmallCog(s);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction face = ray.m_82434_();
            Direction.Axis newAxis = state.m_61138_(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((Direction)state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_() : (state.m_61138_((Property)DirectionalKineticBlock.FACING) ? ((Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() : (state.m_61138_(RotatedPillarKineticBlock.AXIS) ? (Direction.Axis)state.m_61143_(RotatedPillarKineticBlock.AXIS) : Direction.Axis.Y));
            if (face.m_122434_() == newAxis) {
                return PlacementOffset.fail();
            }
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.m_82450_(), face.m_122434_(), newAxis);
            for (Direction d : directions) {
                BlockPos newPos = pos.m_142300_(face).m_142300_(d);
                if (!world.m_8055_(newPos).m_60767_().m_76336_()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition(false, (LevelReader)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    public static class IntegratedSmallCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isSmallCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> !ICogWheel.isDedicatedCogWheel(s.m_60734_()) && ICogWheel.isSmallCog(s);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction face = ray.m_82434_();
            Direction.Axis newAxis = state.m_61138_(HorizontalKineticBlock.HORIZONTAL_FACING) ? ((Direction)state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_() : (state.m_61138_((Property)DirectionalKineticBlock.FACING) ? ((Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_() : (state.m_61138_(RotatedPillarKineticBlock.AXIS) ? (Direction.Axis)state.m_61143_(RotatedPillarKineticBlock.AXIS) : Direction.Axis.Y));
            if (face.m_122434_() == newAxis) {
                return PlacementOffset.fail();
            }
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.m_82450_(), newAxis);
            for (Direction d : directions) {
                BlockPos newPos = pos.m_142300_(d);
                if (!world.m_8055_(newPos).m_60767_().m_76336_()) continue;
                if (!CogWheelBlock.isValidCogwheelPosition(false, (LevelReader)world, newPos, newAxis)) {
                    return PlacementOffset.fail();
                }
                return PlacementOffset.success().at((Vec3i)newPos).withTransform(s -> (BlockState)s.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)newAxis));
            }
            return PlacementOffset.fail();
        }
    }

    @MethodsReturnNonnullByDefault
    public static abstract class DiagonalCogHelper
    implements IPlacementHelper {
        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> ICogWheel.isSmallCog(s) || ICogWheel.isLargeCog(s);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction.Axis axis = ((IRotate)state.m_60734_()).getRotationAxis(state);
            Direction closest = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.m_82450_(), axis).get(0);
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.m_82450_(), axis, (Direction d) -> d.m_122434_() != closest.m_122434_());
            for (Direction dir : directions) {
                BlockPos newPos = pos.m_142300_(dir).m_142300_(closest);
                if (!world.m_8055_(newPos).m_60767_().m_76336_() || !CogWheelBlock.isValidCogwheelPosition(ICogWheel.isLargeCog(state), (LevelReader)world, newPos, axis)) continue;
                return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.m_61124_(RotatedPillarKineticBlock.AXIS, (Comparable)axis));
            }
            return PlacementOffset.fail();
        }

        protected boolean hitOnShaft(BlockState state, BlockHitResult ray) {
            return AllShapes.SIX_VOXEL_POLE.get(((IRotate)state.m_60734_()).getRotationAxis(state)).m_83215_().m_82400_(0.001).m_82390_(ray.m_82450_().m_82546_(ray.m_82450_().m_82517_(Iterate.axisSet)));
        }
    }
}

