/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.tank;

import com.simibubi.create.content.contraptions.fluids.tank.CreativeFluidTankTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Pair;

public class FluidTankConnectivityHandler {
    public static void formTanks(FluidTankTileEntity te) {
        TankSearchCache cache = new TankSearchCache();
        ArrayList<FluidTankTileEntity> frontier = new ArrayList<FluidTankTileEntity>();
        frontier.add(te);
        FluidTankConnectivityHandler.formTanks(te.m_58903_(), (BlockGetter)te.m_58904_(), cache, frontier);
    }

    private static void formTanks(BlockEntityType<?> type, BlockGetter world, TankSearchCache cache, List<FluidTankTileEntity> frontier) {
        PriorityQueue<Pair<Integer, FluidTankTileEntity>> creationQueue = FluidTankConnectivityHandler.makeCreationQueue();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (FluidTankTileEntity fluidTankTileEntity : frontier) {
            BlockPos pos = fluidTankTileEntity.m_58899_();
            minX = Math.min(pos.m_123341_(), minX);
            minZ = Math.min(pos.m_123343_(), minZ);
        }
        minX -= FluidTankTileEntity.getMaxSize();
        minZ -= FluidTankTileEntity.getMaxSize();
        while (!frontier.isEmpty()) {
            FluidTankTileEntity tank = frontier.remove(0);
            BlockPos tankPos = tank.m_58899_();
            if (visited.contains(tankPos)) continue;
            visited.add(tankPos);
            int amount = FluidTankConnectivityHandler.tryToFormNewTank(tank, cache, true);
            if (amount > 1) {
                creationQueue.add((Pair<Integer, FluidTankTileEntity>)Pair.of((Object)amount, (Object)tank));
            }
            for (Direction.Axis axis : Iterate.axes) {
                FluidTankTileEntity nextTank;
                Direction d = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis);
                BlockPos next = tankPos.m_142300_(d);
                if (next.m_123341_() <= minX || next.m_123343_() <= minZ || visited.contains(next) || (nextTank = FluidTankConnectivityHandler.tankAt(type, world, next)) == null || nextTank.m_58901_()) continue;
                frontier.add(nextTank);
            }
        }
        visited.clear();
        while (!creationQueue.isEmpty()) {
            Pair<Integer, FluidTankTileEntity> next = creationQueue.poll();
            FluidTankTileEntity toCreate = (FluidTankTileEntity)next.getValue();
            if (visited.contains(toCreate.m_58899_())) continue;
            visited.add(toCreate.m_58899_());
            FluidTankConnectivityHandler.tryToFormNewTank(toCreate, cache, false);
        }
    }

    public static void splitTank(FluidTankTileEntity te) {
        FluidTankConnectivityHandler.splitTankAndInvalidate(te, null, false);
    }

    private static int tryToFormNewTank(FluidTankTileEntity te, TankSearchCache cache, boolean simulate) {
        int bestWidth = 1;
        int bestAmount = -1;
        if (!te.isController()) {
            return 0;
        }
        for (int w = 1; w <= FluidTankTileEntity.getMaxSize(); ++w) {
            int amount = FluidTankConnectivityHandler.tryToFormNewTankOfWidth(te, w, cache, true);
            if (amount < bestAmount) continue;
            bestWidth = w;
            bestAmount = amount;
        }
        if (!simulate) {
            if (te.width == bestWidth && te.width * te.width * te.height == bestAmount) {
                return bestAmount;
            }
            FluidTankConnectivityHandler.splitTankAndInvalidate(te, cache, false);
            te.applyFluidTankSize(bestAmount);
            FluidTankConnectivityHandler.tryToFormNewTankOfWidth(te, bestWidth, cache, simulate);
            te.updateConnectivity = false;
            te.width = bestWidth;
            te.height = bestAmount / bestWidth / bestWidth;
            BlockState state = te.m_58900_();
            if (FluidTankBlock.isTank(state)) {
                state = (BlockState)state.m_61124_((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
                state = (BlockState)state.m_61124_((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(te.height == 1));
                te.m_58904_().m_7731_(te.m_58899_(), state, 22);
            }
            te.setWindows(te.window);
            te.onFluidStackChanged(te.tankInventory.getFluid());
            te.m_6596_();
        }
        return bestAmount;
    }

    private static int tryToFormNewTankOfWidth(FluidTankTileEntity te, int width, TankSearchCache cache, boolean simulate) {
        int amount = 0;
        int height = 0;
        BlockEntityType type = te.m_58903_();
        Level world = te.m_58904_();
        BlockPos origin = te.m_58899_();
        LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        FluidTank teTank = (FluidTank)capability.orElse(null);
        FluidStack fluid = capability.map(ifh -> ifh.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        block0: for (int yOffset = 0; yOffset < FluidTankTileEntity.getMaxHeight(); ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos controllerPos;
                    BlockPos pos = origin.m_142082_(xOffset, yOffset, zOffset);
                    Optional<FluidTankTileEntity> tank = cache.getOrCache(type, (BlockGetter)world, pos);
                    if (!tank.isPresent()) break block0;
                    FluidTankTileEntity controller = tank.get();
                    int otherWidth = controller.width;
                    if (otherWidth > width || !(controllerPos = controller.m_58899_()).equals((Object)origin) && (controllerPos.m_123341_() < origin.m_123341_() || controllerPos.m_123343_() < origin.m_123343_() || controllerPos.m_123341_() + otherWidth > origin.m_123341_() + width || controllerPos.m_123343_() + otherWidth > origin.m_123343_() + width)) break block0;
                    FluidStack otherFluid = controller.getTankInventory().getFluid();
                    if (!fluid.isEmpty() && !otherFluid.isEmpty() && !fluid.isFluidEqual(otherFluid)) break block0;
                }
            }
            amount += width * width;
            ++height;
        }
        if (simulate) {
            return amount;
        }
        boolean opaque = false;
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = origin.m_142082_(xOffset, yOffset, zOffset);
                    FluidTankTileEntity tank = FluidTankConnectivityHandler.tankAt(type, (BlockGetter)world, pos);
                    if (tank == te) continue;
                    opaque |= !tank.window;
                    FluidTank tankTank = tank.tankInventory;
                    FluidStack fluidInTank = tankTank.getFluid();
                    if (!fluidInTank.isEmpty()) {
                        if (teTank.isEmpty() && teTank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                            ((CreativeFluidTankTileEntity.CreativeSmartFluidTank)teTank).setContainedFluid(fluidInTank);
                        }
                        teTank.fill(fluidInTank, IFluidHandler.FluidAction.EXECUTE);
                    }
                    tankTank.setFluid(FluidStack.EMPTY);
                    FluidTankConnectivityHandler.splitTankAndInvalidate(tank, cache, false);
                    tank.setController(origin);
                    tank.updateConnectivity = false;
                    cache.put(pos, te);
                    BlockState state = world.m_8055_(pos);
                    if (!FluidTankBlock.isTank(state)) continue;
                    state = (BlockState)state.m_61124_((Property)FluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(yOffset == 0));
                    state = (BlockState)state.m_61124_((Property)FluidTankBlock.TOP, (Comparable)Boolean.valueOf(yOffset == height - 1));
                    world.m_7731_(pos, state, 22);
                }
            }
        }
        te.setWindows(!opaque);
        return amount;
    }

    private static void splitTankAndInvalidate(FluidTankTileEntity te, @Nullable TankSearchCache cache, boolean tryReconnect) {
        if ((te = te.getControllerTE()) == null) {
            return;
        }
        int height = te.height;
        int width = te.width;
        if (width == 1 && height == 1) {
            return;
        }
        Level world = te.m_58904_();
        BlockPos origin = te.m_58899_();
        ArrayList<FluidTankTileEntity> frontier = new ArrayList<FluidTankTileEntity>();
        FluidStack toDistribute = te.tankInventory.getFluid().copy();
        int maxCapacity = FluidTankTileEntity.getCapacityMultiplier();
        if (!toDistribute.isEmpty() && !te.m_58901_()) {
            toDistribute.shrink(maxCapacity);
        }
        te.applyFluidTankSize(1);
        for (int yOffset = 0; yOffset < height; ++yOffset) {
            for (int xOffset = 0; xOffset < width; ++xOffset) {
                for (int zOffset = 0; zOffset < width; ++zOffset) {
                    BlockPos pos = origin.m_142082_(xOffset, yOffset, zOffset);
                    FluidTankTileEntity tankAt = FluidTankConnectivityHandler.tankAt(te.m_58903_(), (BlockGetter)world, pos);
                    if (tankAt == null || !tankAt.getController().equals((Object)origin)) continue;
                    FluidTankTileEntity controllerTE = tankAt.getControllerTE();
                    tankAt.window = controllerTE == null || controllerTE.window;
                    tankAt.removeController(true);
                    if (!toDistribute.isEmpty() && tankAt != te) {
                        FluidStack copy = toDistribute.copy();
                        FluidTank tankInventory = tankAt.tankInventory;
                        if (tankInventory.isEmpty() && tankInventory instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
                            ((CreativeFluidTankTileEntity.CreativeSmartFluidTank)tankInventory).setContainedFluid(toDistribute);
                        } else {
                            int split = Math.min(maxCapacity, toDistribute.getAmount());
                            copy.setAmount(split);
                            toDistribute.shrink(split);
                            tankInventory.fill(copy, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    if (tryReconnect) {
                        frontier.add(tankAt);
                        tankAt.updateConnectivity = false;
                    }
                    if (cache == null) continue;
                    cache.put(pos, tankAt);
                }
            }
        }
        te.fluidCapability.invalidate();
        if (tryReconnect) {
            FluidTankConnectivityHandler.formTanks(te.m_58903_(), (BlockGetter)world, cache == null ? new TankSearchCache() : cache, frontier);
        }
    }

    private static PriorityQueue<Pair<Integer, FluidTankTileEntity>> makeCreationQueue() {
        return new PriorityQueue<Pair<Integer, FluidTankTileEntity>>(new Comparator<Pair<Integer, FluidTankTileEntity>>(){

            @Override
            public int compare(Pair<Integer, FluidTankTileEntity> o1, Pair<Integer, FluidTankTileEntity> o2) {
                return (Integer)o2.getKey() - (Integer)o1.getKey();
            }
        });
    }

    @Nullable
    public static FluidTankTileEntity tankAt(BlockEntityType<?> type, BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof FluidTankTileEntity && te.m_58903_() == type) {
            return (FluidTankTileEntity)te;
        }
        return null;
    }

    @Nullable
    public static FluidTankTileEntity anyTankAt(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof FluidTankTileEntity) {
            return (FluidTankTileEntity)te;
        }
        return null;
    }

    public static boolean isConnected(BlockGetter world, BlockPos tankPos, BlockPos otherTankPos) {
        BlockEntity te1 = world.m_7702_(tankPos);
        BlockEntity te2 = world.m_7702_(otherTankPos);
        if (!(te1 instanceof FluidTankTileEntity) || !(te2 instanceof FluidTankTileEntity)) {
            return false;
        }
        return ((FluidTankTileEntity)te1).getController().equals((Object)((FluidTankTileEntity)te2).getController());
    }

    private static class TankSearchCache {
        Map<BlockPos, Optional<FluidTankTileEntity>> controllerMap = new HashMap<BlockPos, Optional<FluidTankTileEntity>>();

        void put(BlockPos pos, FluidTankTileEntity target) {
            this.controllerMap.put(pos, Optional.of(target));
        }

        void putEmpty(BlockPos pos) {
            this.controllerMap.put(pos, Optional.empty());
        }

        boolean hasVisited(BlockPos pos) {
            return this.controllerMap.containsKey(pos);
        }

        Optional<FluidTankTileEntity> getOrCache(BlockEntityType<?> type, BlockGetter world, BlockPos pos) {
            if (this.hasVisited(pos)) {
                return this.controllerMap.get(pos);
            }
            FluidTankTileEntity tankAt = FluidTankConnectivityHandler.tankAt(type, world, pos);
            if (tankAt == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            FluidTankTileEntity controller = tankAt.getControllerTE();
            if (controller == null) {
                this.putEmpty(pos);
                return Optional.empty();
            }
            this.put(pos, controller);
            return Optional.of(controller);
        }
    }
}

