/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.glue;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.GlueEffectPacket;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueItem;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.worldWrappers.RayTraceWorld;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class SuperGlueHandler {
    public static Map<Direction, SuperGlueEntity> gatherGlue(LevelAccessor world, BlockPos pos) {
        List entities = world.m_45976_(SuperGlueEntity.class, new AABB(pos));
        HashMap<Direction, SuperGlueEntity> map = new HashMap<Direction, SuperGlueEntity>();
        for (SuperGlueEntity entity : entities) {
            map.put(entity.getAttachedDirection(pos), entity);
        }
        return map;
    }

    @SubscribeEvent
    public static void glueListensForBlockPlacement(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor world = event.getWorld();
        Entity entity = event.getEntity();
        BlockPos pos = event.getPos();
        if (entity == null || world == null || pos == null) {
            return;
        }
        if (world.m_5776_()) {
            return;
        }
        Map<Direction, SuperGlueEntity> gatheredGlue = SuperGlueHandler.gatherGlue(world, pos);
        for (Direction direction : gatheredGlue.keySet()) {
            AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new GlueEffectPacket(pos, direction, true));
        }
        if (entity instanceof Player) {
            SuperGlueHandler.glueInOffHandAppliesOnBlockPlace(event, pos, (Player)entity);
        }
    }

    public static void glueInOffHandAppliesOnBlockPlace(BlockEvent.EntityPlaceEvent event, BlockPos pos, Player placer) {
        ItemStack itemstack = placer.m_21206_();
        AttributeInstance reachAttribute = placer.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (!AllItems.SUPER_GLUE.isIn(itemstack) || reachAttribute == null) {
            return;
        }
        if (AllItems.WRENCH.isIn(placer.m_21205_())) {
            return;
        }
        if (event.getPlacedAgainst() == IPlacementHelper.ID) {
            return;
        }
        double distance = reachAttribute.m_22135_();
        Vec3 start = placer.m_20299_(1.0f);
        Vec3 look = placer.m_20252_(1.0f);
        Level world = placer.f_19853_;
        RayTraceWorld rayTraceWorld = new RayTraceWorld((LevelAccessor)world, (p, state) -> p.equals((Object)pos) ? Blocks.f_50016_.m_49966_() : state);
        Vec3 end = start.m_82520_(look.f_82479_ * distance, look.f_82480_ * distance, look.f_82481_ * distance);
        BlockHitResult ray = rayTraceWorld.m_45547_(new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)placer));
        Direction face = ray.m_82434_();
        if (face == null || ray.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        if (!ray.m_82425_().m_142300_(face).equals((Object)pos)) {
            event.setCanceled(true);
            return;
        }
        SuperGlueEntity entity = new SuperGlueEntity(world, ray.m_82425_(), face.m_122424_());
        CompoundTag compoundnbt = itemstack.m_41783_();
        if (compoundnbt != null) {
            EntityType.m_20620_((Level)world, (Player)placer, (Entity)entity, (CompoundTag)compoundnbt);
        }
        if (entity.onValidSurface()) {
            if (!world.f_46443_) {
                entity.playPlaceSound();
                world.m_7967_((Entity)entity);
                AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new GlueEffectPacket(ray.m_82425_(), face, true));
            }
            itemstack.m_41622_(1, (LivingEntity)placer, SuperGlueItem::onBroken);
        }
    }
}

