/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel.engine;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.contraptions.components.flywheel.engine.FurnaceEngineInteractions;
import com.simibubi.create.content.contraptions.components.flywheel.engine.FurnaceEngineTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FurnaceEngineBlock
extends EngineBlock
implements ITE<FurnaceEngineTileEntity> {
    public FurnaceEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected boolean isValidBaseBlock(BlockState baseBlock, BlockGetter world, BlockPos pos) {
        return FurnaceEngineInteractions.getHandler(baseBlock).getHeatSource(baseBlock).isValid();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.FURNACE_ENGINE.get((Direction)state.m_61143_((Property)f_54117_));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getFrameModel() {
        return AllBlockPartials.FURNACE_GENERATOR_FRAME;
    }

    @Override
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn instanceof WrappedWorld) {
            return;
        }
        if (worldIn.f_46443_) {
            return;
        }
        if (fromPos.equals((Object)FurnaceEngineBlock.getBaseBlockPos(state, pos)) && this.m_7898_(state, (LevelReader)worldIn, pos)) {
            this.withTileEntityDo((BlockGetter)worldIn, pos, FurnaceEngineTileEntity::updateFurnace);
        }
    }

    @SubscribeEvent
    public static void usingFurnaceEngineOnFurnacePreventsGUI(PlayerInteractEvent.RightClickBlock event) {
        ItemStack item = event.getItemStack();
        if (!(item.m_41720_() instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item.m_41720_();
        if (blockItem.m_40614_() != AllBlocks.FURNACE_ENGINE.get()) {
            return;
        }
        BlockState state = event.getWorld().m_8055_(event.getPos());
        if (event.getFace().m_122434_().m_122478_()) {
            return;
        }
        if (state.m_60734_() instanceof AbstractFurnaceBlock) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    @Override
    public Class<FurnaceEngineTileEntity> getTileEntityClass() {
        return FurnaceEngineTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends FurnaceEngineTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.FURNACE_ENGINE.get();
    }
}

