/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import java.util.Iterator;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class DeployerItemHandler
implements IItemHandlerModifiable {
    private DeployerTileEntity te;
    private DeployerFakePlayer player;

    public DeployerItemHandler(DeployerTileEntity te) {
        this.te = te;
        this.player = te.player;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.getHeld();
    }

    public ItemStack getHeld() {
        if (this.player == null) {
            return ItemStack.f_41583_;
        }
        return this.player.m_21205_();
    }

    public void set(ItemStack stack) {
        if (this.player == null) {
            return;
        }
        if (this.te.m_58904_().f_46443_) {
            return;
        }
        this.player.m_21008_(InteractionHand.MAIN_HAND, stack);
        this.te.m_6596_();
        this.te.sendData();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack held = this.getHeld();
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (held.m_41619_()) {
            if (!simulate) {
                this.set(stack);
            }
            return ItemStack.f_41583_;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)held, (ItemStack)stack)) {
            return stack;
        }
        int space = held.m_41741_() - held.m_41613_();
        ItemStack remainder = stack.m_41777_();
        ItemStack split = remainder.m_41620_(space);
        if (space == 0) {
            return stack;
        }
        if (!simulate) {
            held = held.m_41777_();
            held.m_41764_(held.m_41613_() + split.m_41613_());
            this.set(held);
        }
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack extractedFromOverflow = ItemStack.f_41583_;
        ItemStack returnToOverflow = ItemStack.f_41583_;
        Iterator<ItemStack> iterator = this.te.overflowItems.iterator();
        while (iterator.hasNext()) {
            ItemStack existing = iterator.next();
            if (existing.m_41619_()) {
                iterator.remove();
                continue;
            }
            int toExtract = Math.min(amount, existing.m_41741_());
            if (existing.m_41613_() <= toExtract) {
                if (!simulate) {
                    iterator.remove();
                }
                extractedFromOverflow = existing;
                break;
            }
            if (!simulate) {
                iterator.remove();
                returnToOverflow = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract));
            }
            extractedFromOverflow = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
            break;
        }
        if (!returnToOverflow.m_41619_()) {
            this.te.overflowItems.add(returnToOverflow);
        }
        if (!extractedFromOverflow.m_41619_()) {
            return extractedFromOverflow;
        }
        ItemStack held = this.getHeld();
        if (amount == 0 || held.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.te.filtering.getFilter().m_41619_() && this.te.filtering.test(held)) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            return held.m_41777_().m_41620_(amount);
        }
        ItemStack toReturn = held.m_41620_(amount);
        this.te.m_6596_();
        this.te.sendData();
        return toReturn;
    }

    public int getSlotLimit(int slot) {
        return Math.min(this.getHeld().m_41741_(), 64);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        FilteringBehaviour filteringBehaviour = this.te.getBehaviour(FilteringBehaviour.TYPE);
        return filteringBehaviour == null || filteringBehaviour.test(stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.set(stack);
    }
}

