/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors.dispenser;

import com.simibubi.create.content.contraptions.components.actors.dispenser.ContraptionBlockSource;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DispenseItemLocation;
import com.simibubi.create.content.contraptions.components.actors.dispenser.DropperMovementBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.IMovedDispenseItemBehaviour;
import com.simibubi.create.content.contraptions.components.actors.dispenser.MovedProjectileDispenserBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DispenserMovementBehaviour
extends DropperMovementBehaviour {
    private static final HashMap<Item, IMovedDispenseItemBehaviour> MOVED_DISPENSE_ITEM_BEHAVIOURS = new HashMap();
    private static final HashMap<Item, IMovedDispenseItemBehaviour> MOVED_PROJECTILE_DISPENSE_BEHAVIOURS = new HashMap();
    private static final DispenserLookup BEHAVIOUR_LOOKUP = new DispenserLookup();
    private static boolean spawneggsRegistered = false;

    public static void gatherMovedDispenseItemBehaviours() {
        IMovedDispenseItemBehaviour.init();
    }

    public static void registerMovedDispenseItemBehaviour(Item item, IMovedDispenseItemBehaviour movedDispenseItemBehaviour) {
        MOVED_DISPENSE_ITEM_BEHAVIOURS.put(item, movedDispenseItemBehaviour);
    }

    @Override
    protected void activate(MovementContext context, BlockPos pos) {
        DispenseItemLocation location;
        if (!spawneggsRegistered) {
            spawneggsRegistered = true;
            IMovedDispenseItemBehaviour.initSpawneggs();
        }
        if ((location = this.getDispenseLocation(context)).isEmpty()) {
            context.world.m_46796_(1001, pos, 0);
        } else {
            ItemStack itemstack = this.getItemStackAt(location, context);
            if (MOVED_DISPENSE_ITEM_BEHAVIOURS.containsKey(itemstack.m_41720_())) {
                this.setItemStackAt(location, MOVED_DISPENSE_ITEM_BEHAVIOURS.get(itemstack.m_41720_()).dispense(itemstack, context, pos), context);
                return;
            }
            ItemStack backup = itemstack.m_41777_();
            try {
                if (MOVED_PROJECTILE_DISPENSE_BEHAVIOURS.containsKey(itemstack.m_41720_())) {
                    this.setItemStackAt(location, MOVED_PROJECTILE_DISPENSE_BEHAVIOURS.get(itemstack.m_41720_()).dispense(itemstack, context, pos), context);
                    return;
                }
                DispenseItemBehavior idispenseitembehavior = BEHAVIOUR_LOOKUP.m_7216_(itemstack);
                if (idispenseitembehavior instanceof AbstractProjectileDispenseBehavior) {
                    MovedProjectileDispenserBehaviour iMovedDispenseItemBehaviour = MovedProjectileDispenserBehaviour.of((AbstractProjectileDispenseBehavior)idispenseitembehavior);
                    this.setItemStackAt(location, iMovedDispenseItemBehaviour.dispense(itemstack, context, pos), context);
                    MOVED_PROJECTILE_DISPENSE_BEHAVIOURS.put(itemstack.m_41720_(), iMovedDispenseItemBehaviour);
                    return;
                }
                Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)DispenserBlock.f_52659_)).m_122436_());
                facingVec = (Vec3)context.rotation.apply(facingVec);
                facingVec.m_82541_();
                Direction clostestFacing = Direction.m_122366_((double)facingVec.f_82479_, (double)facingVec.f_82480_, (double)facingVec.f_82481_);
                ContraptionBlockSource blockSource = new ContraptionBlockSource(context, pos, clostestFacing);
                if (idispenseitembehavior.getClass() != DefaultDispenseItemBehavior.class) {
                    this.setItemStackAt(location, idispenseitembehavior.m_6115_((BlockSource)blockSource, itemstack), context);
                    return;
                }
            }
            catch (NullPointerException ignored) {
                itemstack = backup;
            }
            this.setItemStackAt(location, defaultBehaviour.dispense(itemstack, context, pos), context);
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class DispenserLookup
    extends DispenserBlock {
        protected DispenserLookup() {
            super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50061_));
        }

        public DispenseItemBehavior m_7216_(ItemStack itemStack) {
            return super.m_7216_(itemStack);
        }
    }
}

