/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.components.actors.PSIActorInstance;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceRenderer;
import com.simibubi.create.content.contraptions.components.actors.PortableStorageInterfaceTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ActorInstance;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class PortableStorageInterfaceMovement
extends MovementBehaviour {
    static final String _workingPos_ = "WorkingPos";
    static final String _clientPrevPos_ = "ClientPrevPos";

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)PortableStorageInterfaceBlock.f_52588_)).m_122436_()).m_82490_((double)1.85f);
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return new PSIActorInstance(materialManager, simulationWorld, context);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        if (!Backend.isOn()) {
            PortableStorageInterfaceRenderer.renderInContraption(context, renderWorld, matrices, buffer);
        }
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        context.data.m_128473_(_workingPos_);
        if (this.findInterface(context, pos)) {
            context.stall = true;
        }
    }

    protected boolean findInterface(MovementContext context, BlockPos pos) {
        Optional<Direction> currentFacingIfValid = this.getCurrentFacingIfValid(context);
        if (!currentFacingIfValid.isPresent()) {
            return false;
        }
        Direction currentFacing = currentFacingIfValid.get();
        PortableStorageInterfaceTileEntity psi = this.findStationaryInterface(context.world, pos, context.state, currentFacing);
        if (psi == null) {
            return false;
        }
        if ((psi.isTransferring() || psi.isPowered()) && !context.world.f_46443_) {
            return false;
        }
        context.data.m_128365_(_workingPos_, (Tag)NbtUtils.m_129224_((BlockPos)psi.m_58899_()));
        if (!context.world.f_46443_) {
            Vec3 diff = VecHelper.getCenterOf((Vec3i)psi.m_58899_()).m_82546_(context.position);
            diff = VecHelper.project(diff, Vec3.m_82528_((Vec3i)currentFacing.m_122436_()));
            float distance = (float)(diff.m_82553_() + (double)1.85f - 1.0);
            psi.startTransferringTo(context.contraption, distance);
        } else {
            context.data.m_128365_(_clientPrevPos_, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        }
        return true;
    }

    @Override
    public void tick(MovementContext context) {
        if (context.world.f_46443_) {
            boolean stalled = context.contraption.stalled;
            if (stalled && !context.data.m_128441_(_workingPos_)) {
                BlockPos pos = new BlockPos(context.position);
                if (!context.data.m_128441_(_clientPrevPos_) || !NbtUtils.m_129239_((CompoundTag)context.data.m_128469_(_clientPrevPos_)).equals((Object)pos)) {
                    this.findInterface(context, pos);
                }
            }
            if (!stalled) {
                this.reset(context);
            }
            return;
        }
        if (!context.data.m_128441_(_workingPos_)) {
            return;
        }
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)context.data.m_128469_(_workingPos_));
        Optional<Direction> currentFacingIfValid = this.getCurrentFacingIfValid(context);
        if (!currentFacingIfValid.isPresent()) {
            return;
        }
        PortableStorageInterfaceTileEntity stationaryInterface = this.getStationaryInterfaceAt(context.world, pos, context.state, currentFacingIfValid.get());
        if (stationaryInterface == null || !stationaryInterface.isTransferring()) {
            this.reset(context);
            return;
        }
    }

    @Override
    public void stopMoving(MovementContext context) {
        this.reset(context);
    }

    public void reset(MovementContext context) {
        context.data.m_128473_(_clientPrevPos_);
        context.data.m_128473_(_workingPos_);
        context.stall = false;
    }

    private PortableStorageInterfaceTileEntity findStationaryInterface(Level world, BlockPos pos, BlockState state, Direction facing) {
        for (int i = 0; i < 2; ++i) {
            PortableStorageInterfaceTileEntity interfaceAt = this.getStationaryInterfaceAt(world, pos.m_5484_(facing, i), state, facing);
            if (interfaceAt == null) continue;
            return interfaceAt;
        }
        return null;
    }

    private PortableStorageInterfaceTileEntity getStationaryInterfaceAt(Level world, BlockPos pos, BlockState state, Direction facing) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof PortableStorageInterfaceTileEntity)) {
            return null;
        }
        BlockState blockState = world.m_8055_(pos);
        if (blockState.m_60734_() != state.m_60734_()) {
            return null;
        }
        if (blockState.m_61143_((Property)PortableStorageInterfaceBlock.f_52588_) != facing.m_122424_()) {
            return null;
        }
        return (PortableStorageInterfaceTileEntity)te;
    }

    private Optional<Direction> getCurrentFacingIfValid(MovementContext context) {
        Direction facingFromVector;
        Vec3 directionVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)PortableStorageInterfaceBlock.f_52588_)).m_122436_());
        if ((directionVec = (Vec3)context.rotation.apply(directionVec)).m_82554_(Vec3.m_82528_((Vec3i)(facingFromVector = Direction.m_122366_((double)directionVec.f_82479_, (double)directionVec.f_82480_, (double)directionVec.f_82481_)).m_122436_())) > 0.5) {
            return Optional.empty();
        }
        return Optional.of(facingFromVector);
    }
}

