/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.base;

import com.simibubi.create.content.contraptions.KineticNetwork;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class GeneratingKineticTileEntity
extends KineticTileEntity {
    public boolean reActivateSource;

    public GeneratingKineticTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void notifyStressCapacityChange(float capacity) {
        this.getOrCreateNetwork().updateCapacityFor(this, capacity);
    }

    @Override
    public void removeSource() {
        if (this.hasSource() && this.isSource()) {
            this.reActivateSource = true;
        }
        super.removeSource();
    }

    @Override
    public void setSource(BlockPos source) {
        super.setSource(source);
        BlockEntity tileEntity = this.f_58857_.m_7702_(source);
        if (!(tileEntity instanceof KineticTileEntity)) {
            return;
        }
        KineticTileEntity sourceTe = (KineticTileEntity)tileEntity;
        if (this.reActivateSource && Math.abs(sourceTe.getSpeed()) >= Math.abs(this.getGeneratedSpeed())) {
            this.reActivateSource = false;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.reActivateSource) {
            this.updateGeneratedRotation();
            this.reActivateSource = false;
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        float stressBase = this.calculateAddedStressCapacity();
        if (stressBase != 0.0f && IRotate.StressImpact.isEnabled()) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("gui.goggles.generator_stats", new Object[0])));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translate("tooltip.capacityProvided", new Object[0]).m_130940_(ChatFormatting.GRAY)));
            float speed = this.getTheoreticalSpeed();
            if (speed != this.getGeneratedSpeed() && speed != 0.0f) {
                stressBase *= this.getGeneratedSpeed() / speed;
            }
            speed = Math.abs(speed);
            float stressTotal = stressBase * speed;
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TextComponent(" " + IHaveGoggleInformation.format(stressTotal)).m_7220_((Component)Lang.translate("generic.unit.stress", new Object[0])).m_130940_(ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)Lang.translate("gui.goggles.at_current_speed", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY)));
            added = true;
        }
        return added;
    }

    public void updateGeneratedRotation() {
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (prevSpeed != speed) {
            IRotate.SpeedLevel levelafter;
            IRotate.SpeedLevel levelBefore;
            if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of(this.speed)) != (levelafter = IRotate.SpeedLevel.of(speed))) {
                this.effects.queueRotationIndicators();
            }
            this.applyNewSpeed(prevSpeed, speed);
        }
        if (this.hasNetwork() && speed != 0.0f) {
            KineticNetwork network = this.getOrCreateNetwork();
            this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
            this.getOrCreateNetwork().updateStressFor(this, this.calculateStressApplied());
            network.updateStress();
        }
        this.onSpeedChanged(prevSpeed);
        this.sendData();
    }

    public void applyNewSpeed(float prevSpeed, float speed) {
        if (speed == 0.0f) {
            if (this.hasSource()) {
                this.notifyStressCapacityChange(0.0f);
                this.getOrCreateNetwork().updateStressFor(this, this.calculateStressApplied());
                return;
            }
            this.detachKinetics();
            this.setSpeed(0.0f);
            this.setNetwork(null);
            return;
        }
        if (prevSpeed == 0.0f) {
            this.setSpeed(speed);
            this.setNetwork(this.createNetworkId());
            this.attachKinetics();
            return;
        }
        if (this.hasSource()) {
            if (Math.abs(prevSpeed) >= Math.abs(speed)) {
                if (Math.signum(prevSpeed) != Math.signum(speed)) {
                    this.f_58857_.m_46961_(this.f_58858_, true);
                }
                return;
            }
            this.detachKinetics();
            this.setSpeed(speed);
            this.source = null;
            this.setNetwork(this.createNetworkId());
            this.attachKinetics();
            return;
        }
        this.detachKinetics();
        this.setSpeed(speed);
        this.attachKinetics();
    }

    public Long createNetworkId() {
        return this.f_58858_.m_121878_();
    }
}

