/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedItemDrain;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.EmptyingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class ItemDrainCategory
extends CreateRecipeCategory<EmptyingRecipe> {
    AnimatedItemDrain drain = new AnimatedItemDrain();

    public ItemDrainCategory() {
        super(ItemDrainCategory.doubleItemIcon((ItemLike)AllBlocks.ITEM_DRAIN.get(), (ItemLike)Items.f_42447_), ItemDrainCategory.emptyBackground(177, 50));
    }

    public static List<EmptyingRecipe> getRecipes(IIngredientManager ingredientManager) {
        ArrayList<EmptyingRecipe> recipes = new ArrayList<EmptyingRecipe>();
        ingredientManager.getAllIngredients(VanillaTypes.ITEM).stream().forEach(stack -> {
            if (stack.m_41720_() instanceof PotionItem) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                Ingredient potion = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
                recipes.add(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("potions")).withItemIngredients(potion).withFluidOutputs(fluidFromPotionItem).withSingleItemOutput(new ItemStack((ItemLike)Items.f_42590_)).build());
                return;
            }
            LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            if (!capability.isPresent()) {
                return;
            }
            ItemStack copy = stack.m_41777_();
            capability = copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            IFluidHandlerItem handler = (IFluidHandlerItem)capability.orElse(null);
            FluidStack extracted = handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            ItemStack result = handler.getContainer();
            if (extracted.isEmpty()) {
                return;
            }
            if (result.m_41619_()) {
                return;
            }
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            ResourceLocation itemName = stack.m_41720_().getRegistryName();
            ResourceLocation fluidName = extracted.getFluid().getRegistryName();
            recipes.add(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("empty_" + itemName.m_135827_() + "_" + itemName.m_135815_() + "_of_" + fluidName.m_135827_() + "_" + fluidName.m_135815_())).withItemIngredients(ingredient).withFluidOutputs(extracted).withSingleItemOutput(result).build());
        });
        return recipes;
    }

    public Class<? extends EmptyingRecipe> getRecipeClass() {
        return EmptyingRecipe.class;
    }

    public void setIngredients(EmptyingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        if (!recipe.getRollableResults().isEmpty()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
        }
        if (!recipe.getFluidResults().isEmpty()) {
            ingredients.setOutputs(VanillaTypes.FLUID, recipe.getFluidResults());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, EmptyingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        FluidStack fluidOutput = recipe.getResultingFluid();
        List<ItemStack> matchingIngredients = Arrays.asList(((Ingredient)recipe.m_7527_().get(0)).m_43908_());
        fluidStacks.init(0, false, 132, 8);
        fluidStacks.set(0, ItemDrainCategory.withImprovedVisibility(fluidOutput));
        itemStacks.init(0, true, 26, 7);
        itemStacks.set(0, matchingIngredients);
        itemStacks.init(1, false, 131, 26);
        itemStacks.set(1, recipe.m_8043_());
        ItemDrainCategory.addFluidTooltip(fluidStacks, Collections.emptyList(), (List<FluidStack>)ImmutableList.of((Object)fluidOutput));
    }

    public void draw(EmptyingRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.render(matrixStack, 131, 7);
        AllGuiTextures.JEI_SLOT.render(matrixStack, 26, 7);
        ItemDrainCategory.getRenderedSlot(recipe, 0).render(matrixStack, 131, 26);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 62, 37);
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 73, 4);
        this.drain.withFluid(recipe.getResultingFluid()).draw(matrixStack, this.getBackground().getWidth() / 2 - 13, 40);
    }
}

