/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedDeployer;
import com.simibubi.create.content.contraptions.components.deployer.DeployerApplicationRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Arrays;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.ChatFormatting;
import net.minecraft.world.level.ItemLike;

public class DeployingCategory
extends CreateRecipeCategory<DeployerApplicationRecipe> {
    AnimatedDeployer deployer = new AnimatedDeployer();

    public DeployingCategory() {
        super(DeployingCategory.itemIcon((ItemLike)AllBlocks.DEPLOYER.get()), DeployingCategory.emptyBackground(177, 70));
    }

    public Class<DeployerApplicationRecipe> getRecipeClass() {
        return DeployerApplicationRecipe.class;
    }

    public void setIngredients(DeployerApplicationRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.m_7527_());
        ingredients.setInputLists(VanillaTypes.FLUID, recipe.getFluidIngredients().stream().map(FluidIngredient::getMatchingFluidStacks).collect(Collectors.toList()));
        if (!recipe.getRollableResults().isEmpty()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, DeployerApplicationRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 26, 50);
        itemStacks.set(0, Arrays.asList(recipe.getProcessedItem().m_43908_()));
        itemStacks.init(1, true, 50, 4);
        itemStacks.set(1, Arrays.asList(recipe.getRequiredHeldItem().m_43908_()));
        itemStacks.init(2, false, 131, 50);
        itemStacks.set(2, recipe.m_8043_());
        if (recipe.shouldKeepHeldItem()) {
            itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (!input) {
                    return;
                }
                if (slotIndex != 1) {
                    return;
                }
                tooltip.add(1, Lang.translate("recipe.deploying.not_consumed", new Object[0]).m_130940_(ChatFormatting.GOLD));
            });
        }
        DeployingCategory.addStochasticTooltip(itemStacks, recipe.getRollableResults(), 2);
    }

    public void draw(DeployerApplicationRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.render(matrixStack, 50, 4);
        AllGuiTextures.JEI_SLOT.render(matrixStack, 26, 50);
        DeployingCategory.getRenderedSlot(recipe, 0).render(matrixStack, 131, 50);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 126, 29);
        this.deployer.draw(matrixStack, this.getBackground().getWidth() / 2 - 13, 22);
    }
}

