/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.AllFluids;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class CreateRecipeCategory<T extends Recipe<?>>
implements IRecipeCategory<T> {
    public final List<Supplier<List<? extends Recipe<?>>>> recipes = new ArrayList();
    public final List<Supplier<? extends ItemStack>> recipeCatalysts = new ArrayList<Supplier<? extends ItemStack>>();
    protected ResourceLocation uid;
    protected String name;
    private IDrawable background;
    private IDrawable icon;

    public CreateRecipeCategory(IDrawable icon, IDrawable background) {
        this.background = background;
        this.icon = icon;
    }

    public void setCategoryId(String name) {
        this.uid = Create.asResource(name);
        this.name = name;
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public Component getTitle() {
        return Lang.translate("recipe." + this.name, new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public static AllGuiTextures getRenderedSlot(Recipe<?> recipe, int index) {
        AllGuiTextures jeiSlot = AllGuiTextures.JEI_SLOT;
        if (!(recipe instanceof ProcessingRecipe)) {
            return jeiSlot;
        }
        ProcessingRecipe processingRecipe = (ProcessingRecipe)recipe;
        NonNullList<ProcessingOutput> rollableResults = processingRecipe.getRollableResults();
        if (rollableResults.size() <= index) {
            return jeiSlot;
        }
        if (((ProcessingOutput)processingRecipe.getRollableResults().get(index)).getChance() == 1.0f) {
            return jeiSlot;
        }
        return AllGuiTextures.JEI_CHANCE_SLOT;
    }

    public static IDrawable emptyBackground(int width, int height) {
        return new EmptyBackground(width, height);
    }

    public static IDrawable doubleItemIcon(ItemLike item1, ItemLike item2) {
        return new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2));
    }

    public static IDrawable itemIcon(ItemLike item) {
        return new DoubleItemIcon(() -> new ItemStack(item), () -> ItemStack.f_41583_);
    }

    public static void addStochasticTooltip(IGuiItemStackGroup itemStacks, List<ProcessingOutput> results) {
        CreateRecipeCategory.addStochasticTooltip(itemStacks, results, 1);
    }

    public static void addStochasticTooltip(IGuiItemStackGroup itemStacks, List<ProcessingOutput> results, int startIndex) {
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                return;
            }
            if (slotIndex < startIndex) {
                return;
            }
            ProcessingOutput output = (ProcessingOutput)results.get(slotIndex - startIndex);
            float chance = output.getChance();
            if (chance != 1.0f) {
                tooltip.add(1, Lang.translate("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).m_130940_(ChatFormatting.GOLD));
            }
        });
    }

    public static List<FluidStack> withImprovedVisibility(List<FluidStack> stacks) {
        return stacks.stream().map(CreateRecipeCategory::withImprovedVisibility).collect(Collectors.toList());
    }

    public static FluidStack withImprovedVisibility(FluidStack stack) {
        FluidStack display = stack.copy();
        int displayedAmount = (int)((float)stack.getAmount() * 0.75f) + 250;
        display.setAmount(displayedAmount);
        return display;
    }

    public static void addFluidTooltip(IGuiFluidStackGroup fluidStacks, List<FluidIngredient> inputs, List<FluidStack> outputs) {
        CreateRecipeCategory.addFluidTooltip(fluidStacks, inputs, outputs, -1);
    }

    public static void addFluidTooltip(IGuiFluidStackGroup fluidStacks, List<FluidIngredient> inputs, List<FluidStack> outputs, int index) {
        ArrayList amounts = new ArrayList();
        inputs.forEach(f -> amounts.add(f.getRequiredAmount()));
        outputs.forEach(f -> amounts.add(f.getAmount()));
        fluidStacks.addTooltipCallback((slotIndex, input, fluid, tooltip) -> {
            if (index != -1 && slotIndex != index) {
                return;
            }
            if (fluid.getFluid().m_6212_((Fluid)AllFluids.POTION.get())) {
                Component name = fluid.getDisplayName();
                if (tooltip.isEmpty()) {
                    tooltip.add(0, name);
                } else {
                    tooltip.set(0, name);
                }
                ArrayList<Component> potionTooltip = new ArrayList<Component>();
                PotionFluidHandler.addPotionTooltip(fluid, potionTooltip, 1.0f);
                tooltip.addAll(1, potionTooltip.stream().collect(Collectors.toList()));
            }
            int amount = (Integer)amounts.get(index != -1 ? 0 : slotIndex);
            MutableComponent text = Lang.translate("generic.unit.millibuckets", amount).m_130940_(ChatFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((Component)tooltip.get(0)).m_7360_();
                siblings.add(new TextComponent(" "));
                siblings.add(text);
            }
        });
    }
}

