/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.ingredients.IngredientTypeHelper;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.util.MathUtil;
import net.minecraft.client.renderer.Rect2i;

public class IngredientListSlot {
    private final Rect2i area;
    private final int padding;
    private boolean blocked = false;
    @Nullable
    private IngredientListElementRenderer<?> ingredientRenderer;

    public IngredientListSlot(int xPosition, int yPosition, int padding) {
        this.padding = padding;
        int size = 16 + 2 * padding;
        this.area = new Rect2i(xPosition, yPosition, size, size);
    }

    @Nullable
    public IngredientListElementRenderer<?> getIngredientRenderer() {
        return this.ingredientRenderer;
    }

    @Nullable
    public <T> IngredientListElementRenderer<T> getIngredientRenderer(IIngredientType<T> ingredientType) {
        return IngredientTypeHelper.checkedCast(this.ingredientRenderer, ingredientType);
    }

    public void clear() {
        this.ingredientRenderer = null;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.ingredientRenderer != null && MathUtil.contains(this.area, mouseX, mouseY);
    }

    public void setIngredientRenderer(IngredientListElementRenderer<?> ingredientRenderer) {
        this.ingredientRenderer = ingredientRenderer;
        ingredientRenderer.setArea(this.area);
        ingredientRenderer.setPadding(this.padding);
    }

    public Rect2i getArea() {
        return this.area;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isBlocked() {
        return this.blocked;
    }
}

