/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ISlowRenderItem;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.ingredients.IngredientInfo;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.render.IngredientListBatches;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IngredientListBatchRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int BLACKLIST_COLOR = -65536;
    private final List<IngredientListSlot> slots = new ArrayList<IngredientListSlot>();
    private final List<IngredientListElementRenderer<ItemStack>> renderItems2d = new ArrayList<IngredientListElementRenderer<ItemStack>>();
    private final List<IngredientListElementRenderer<ItemStack>> renderItems3d = new ArrayList<IngredientListElementRenderer<ItemStack>>();
    private final IngredientListBatches renderOther = new IngredientListBatches();
    private final IClientConfig clientConfig;
    private final IEditModeConfig editModeConfig;
    private final IWorldConfig worldConfig;
    private final IngredientManager ingredientManager;
    private int blocked = 0;

    public IngredientListBatchRenderer(IClientConfig clientConfig, IEditModeConfig editModeConfig, IWorldConfig worldConfig, IngredientManager ingredientManager) {
        this.clientConfig = clientConfig;
        this.editModeConfig = editModeConfig;
        this.worldConfig = worldConfig;
        this.ingredientManager = ingredientManager;
    }

    public void clear() {
        this.slots.clear();
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
    }

    public int size() {
        return this.slots.size() - this.blocked;
    }

    public void add(IngredientListSlot ingredientListSlot) {
        this.slots.add(ingredientListSlot);
    }

    public List<IngredientListSlot> getAllGuiIngredientSlots() {
        return this.slots;
    }

    public void set(int startIndex, List<?> ingredientList) {
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.blocked = 0;
        int i = startIndex;
        for (IngredientListSlot ingredientListSlot : this.slots) {
            if (ingredientListSlot.isBlocked()) {
                ingredientListSlot.clear();
                ++this.blocked;
                continue;
            }
            if (i >= ingredientList.size()) {
                ingredientListSlot.clear();
            } else {
                Object ingredient = ingredientList.get(i);
                this.set(ingredientListSlot, ingredient);
            }
            ++i;
        }
    }

    private <V> void set(IngredientListSlot ingredientListSlot, V ingredient) {
        ingredientListSlot.clear();
        if (ingredient instanceof ItemStack) {
            BakedModel bakedModel;
            ItemStack itemStack = (ItemStack)ingredient;
            Minecraft minecraft = Minecraft.m_91087_();
            ItemRenderer itemRenderer = minecraft.m_91291_();
            try {
                bakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
                Preconditions.checkNotNull((Object)bakedModel, (Object)"IBakedModel must not be null.");
            }
            catch (Throwable throwable) {
                String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
                LOGGER.error("ItemStack crashed getting IBakedModel. {}", (Object)stackInfo, (Object)throwable);
                return;
            }
            if (!(bakedModel.m_7521_() || bakedModel.isLayered() || itemStack.m_41720_() instanceof ISlowRenderItem)) {
                IngredientListElementRenderer<ItemStack> renderer = new IngredientListElementRenderer<ItemStack>(itemStack);
                ingredientListSlot.setIngredientRenderer(renderer);
                if (bakedModel.m_7547_()) {
                    this.renderItems3d.add(renderer);
                } else {
                    this.renderItems2d.add(renderer);
                }
                return;
            }
        }
        IngredientListElementRenderer<V> renderer = new IngredientListElementRenderer<V>(ingredient);
        ingredientListSlot.setIngredientRenderer(renderer);
        IIngredientType<V> ingredientType = this.ingredientManager.getIngredientType(ingredient);
        this.renderOther.put(ingredientType, renderer);
    }

    @Nullable
    public ClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        IngredientListElementRenderer<?> hovered = this.getHovered(mouseX, mouseY);
        if (hovered != null) {
            return ClickedIngredient.create(hovered.getIngredient(), hovered.getArea());
        }
        return null;
    }

    @Nullable
    public IngredientListElementRenderer<?> getHovered(double mouseX, double mouseY) {
        for (IngredientListSlot slot : this.slots) {
            if (!slot.isMouseOver(mouseX, mouseY)) continue;
            return slot.getIngredientRenderer();
        }
        return null;
    }

    public <T> Optional<IngredientListElementRenderer<T>> getHovered(double mouseX, double mouseY, IIngredientType<T> ingredientType) {
        return this.slots.stream().filter(s -> s.isMouseOver(mouseX, mouseY)).map(s -> s.getIngredientRenderer(ingredientType)).filter(Objects::nonNull).findFirst();
    }

    public void render(Minecraft minecraft, PoseStack poseStack) {
        if (this.clientConfig.isFastItemRenderingEnabled()) {
            this.renderBatchedItemStacks(minecraft, poseStack);
        } else {
            IngredientInfo<ItemStack> ingredientInfo = this.ingredientManager.getIngredientInfo(VanillaTypes.ITEM);
            IIngredientRenderer<ItemStack> ingredientRenderer = ingredientInfo.getIngredientRenderer();
            IIngredientHelper<ItemStack> ingredientHelper = ingredientInfo.getIngredientHelper();
            for (IngredientListElementRenderer<ItemStack> slot : this.renderItems3d) {
                this.renderIngredient(poseStack, slot, ingredientRenderer, ingredientHelper);
            }
            for (IngredientListElementRenderer<ItemStack> slot : this.renderItems2d) {
                this.renderIngredient(poseStack, slot, ingredientRenderer, ingredientHelper);
            }
        }
        for (IIngredientType<?> ingredientType : this.renderOther.getTypes()) {
            this.renderIngredientType(poseStack, ingredientType);
        }
    }

    public void renderBatchedItemStacks(Minecraft minecraft, PoseStack poseStack) {
        if (this.renderItems2d.isEmpty() && this.renderItems3d.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = minecraft.m_91291_();
        itemRenderer.f_115093_ += 50.0f;
        TextureManager textureManager = minecraft.m_91097_();
        textureManager.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
        IngredientInfo<ItemStack> registeredItemstack = this.ingredientManager.getIngredientInfo(VanillaTypes.ITEM);
        IIngredientHelper<ItemStack> itemStackHelper = registeredItemstack.getIngredientHelper();
        IIngredientRenderer<ItemStack> itemStackRenderer = registeredItemstack.getIngredientRenderer();
        this.renderItemStackBatch(poseStack, itemRenderer, buffer, itemStackHelper, this.renderItems3d);
        Lighting.m_84930_();
        this.renderItemStackBatch(poseStack, itemRenderer, buffer, itemStackHelper, this.renderItems2d);
        Lighting.m_84931_();
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        textureManager.m_118506_(InventoryMenu.f_39692_).restoreLastBlurMipmap();
        itemRenderer.f_115093_ -= 50.0f;
        for (IngredientListElementRenderer<ItemStack> slot : this.renderItems3d) {
            IngredientListBatchRenderer.renderOverlay(itemStackRenderer, slot);
        }
        for (IngredientListElementRenderer<ItemStack> slot : this.renderItems2d) {
            IngredientListBatchRenderer.renderOverlay(itemStackRenderer, slot);
        }
        RenderSystem.m_157182_();
    }

    private void renderItemStackFast(PoseStack poseStack, ItemRenderer itemRenderer, MultiBufferSource.BufferSource buffer, IIngredientHelper<ItemStack> itemStackHelper, IngredientListElementRenderer<ItemStack> slot) {
        ItemStack itemStack = slot.getIngredient();
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientListBatchRenderer.renderEditMode(poseStack, slot.getArea(), slot.getPadding(), this.editModeConfig, itemStack, itemStackHelper);
            RenderSystem.m_69478_();
        }
        Rect2i area = slot.getArea();
        int padding = slot.getPadding();
        try {
            BakedModel bakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
            poseStack.m_85836_();
            poseStack.m_85837_((double)(area.m_110085_() + padding) / 16.0, (double)(area.m_110086_() + padding) / -16.0, 0.0);
            itemRenderer.m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
            poseStack.m_85849_();
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, itemStack);
        }
    }

    private static void renderOverlay(IIngredientRenderer<ItemStack> renderer, IngredientListElementRenderer<ItemStack> slot) {
        ItemStack itemStack = slot.getIngredient();
        Rect2i area = slot.getArea();
        int padding = slot.getPadding();
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            Font font = renderer.getFontRenderer(minecraft, itemStack);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            itemRenderer.m_115174_(font, itemStack, area.m_110085_() + padding, area.m_110086_() + padding, null);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, itemStack);
        }
    }

    private <T> void renderIngredientType(PoseStack poseStack, IIngredientType<T> ingredientType) {
        List<IngredientListElementRenderer<T>> slots = this.renderOther.get(ingredientType);
        IngredientInfo<T> ingredientInfo = this.ingredientManager.getIngredientInfo(ingredientType);
        IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();
        IIngredientHelper<T> ingredientHelper = ingredientInfo.getIngredientHelper();
        for (IngredientListElementRenderer<T> slot : slots) {
            this.renderIngredient(poseStack, slot, ingredientRenderer, ingredientHelper);
        }
    }

    private <T> void renderIngredient(PoseStack poseStack, IngredientListElementRenderer<T> slot, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper) {
        T ingredient = slot.getIngredient();
        Rect2i area = slot.getArea();
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientListBatchRenderer.renderEditMode(poseStack, area, slot.getPadding(), this.editModeConfig, ingredient, ingredientHelper);
            RenderSystem.m_69478_();
        }
        try {
            ingredientRenderer.render(poseStack, area.m_110085_() + slot.getPadding(), area.m_110086_() + slot.getPadding(), ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, ingredient);
        }
    }

    private static <T> void renderEditMode(PoseStack poseStack, Rect2i area, int padding, IEditModeConfig editModeConfig, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (editModeConfig.isIngredientOnConfigBlacklist(ingredient, ingredientHelper)) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(area.m_110085_() + padding), (int)(area.m_110086_() + padding), (int)(area.m_110085_() + 16 + padding), (int)(area.m_110086_() + 16 + padding), (int)-65536);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderItemStackBatch(PoseStack poseStack, ItemRenderer itemRenderer, MultiBufferSource.BufferSource buffer, IIngredientHelper<ItemStack> itemStackHelper, List<IngredientListElementRenderer<ItemStack>> slots) {
        for (IngredientListElementRenderer<ItemStack> slot : slots) {
            this.renderItemStackFast(poseStack, itemRenderer, buffer, itemStackHelper, slot);
        }
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_(16.0, 0.0, (double)(100.0f + itemRenderer.f_115093_));
        modelViewStack.m_85841_(16.0f, -16.0f, 16.0f);
        modelViewStack.m_85837_(-0.5, -0.5, -0.5);
        RenderSystem.m_157182_();
        buffer.m_109911_();
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }
}

