/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.recipes.RecipeCategoryData;
import net.minecraft.resources.ResourceLocation;

public class RecipeCategoryDataMap {
    private final ImmutableMap<ResourceLocation, RecipeCategoryData<?>> map;

    public RecipeCategoryDataMap(List<IRecipeCategory<?>> recipeCategories, ImmutableListMultimap<IRecipeCategory<?>, Object> recipeCatalystsMap) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (IRecipeCategory<?> recipeCategory : recipeCategories) {
            ImmutableList recipeCatalysts = recipeCatalystsMap.get(recipeCategory);
            mapBuilder.put((Object)recipeCategory.getUid(), new RecipeCategoryData(recipeCategory, (ImmutableList<Object>)recipeCatalysts));
        }
        this.map = mapBuilder.build();
    }

    public <T> RecipeCategoryData<T> get(IRecipeCategory<T> recipeCategory) {
        ResourceLocation recipeCategoryUid = recipeCategory.getUid();
        RecipeCategoryData<?> recipeCategoryData = this.get(recipeCategoryUid);
        return recipeCategoryData;
    }

    public <T> RecipeCategoryData<T> get(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeCategoryData<?> recipeCategoryData = this.get(recipeCategoryUid);
        IRecipeCategory<?> recipeCategory = recipeCategoryData.getRecipeCategory();
        Class<?> recipeClass = recipeCategory.getRecipeClass();
        if (!recipeClass.isInstance(recipe)) {
            throw new IllegalArgumentException(recipeCategory.getUid() + " recipes must be an instance of " + recipeClass + ". Instead got: " + recipe.getClass());
        }
        RecipeCategoryData<?> castRecipeCategoryData = recipeCategoryData;
        return castRecipeCategoryData;
    }

    public RecipeCategoryData<?> get(ResourceLocation recipeCategoryUid) {
        RecipeCategoryData recipeCategoryData = (RecipeCategoryData)this.map.get((Object)recipeCategoryUid);
        if (recipeCategoryData == null) {
            throw new IllegalStateException("There is no recipe category registered for: " + recipeCategoryUid);
        }
        return recipeCategoryData;
    }

    public void validate(ResourceLocation recipeCategoryUid) {
        if (!this.map.containsKey((Object)recipeCategoryUid)) {
            throw new IllegalStateException("There is no recipe category registered for: " + recipeCategoryUid);
        }
    }
}

