/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting.replacers;

import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraftforge.common.Tags;

public final class ShulkerBoxColoringRecipeMaker {
    public static Stream<CraftingRecipe> createRecipes() {
        String group = "jei.shulker.color";
        ItemStack baseShulkerStack = new ItemStack((ItemLike)Blocks.f_50456_);
        Ingredient baseShulkerIngredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{baseShulkerStack});
        return Arrays.stream(DyeColor.values()).map(color -> {
            DyeItem dye = DyeItem.m_41082_((DyeColor)color);
            ItemStack dyeStack = new ItemStack((ItemLike)dye);
            Tags.IOptionalNamedTag colorTag = color.getTag();
            Ingredient.ItemValue dyeList = new Ingredient.ItemValue(dyeStack);
            Ingredient.TagValue colorList = new Ingredient.TagValue((Tag)colorTag);
            Stream<Ingredient.Value> colorIngredientStream = Stream.of(dyeList, colorList);
            Ingredient colorIngredient = Ingredient.m_43938_(colorIngredientStream);
            NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseShulkerIngredient, colorIngredient});
            Block coloredShulkerBox = ShulkerBoxBlock.m_56190_((DyeColor)color);
            ItemStack output = new ItemStack((ItemLike)coloredShulkerBox);
            ResourceLocation id = new ResourceLocation("minecraft", "jei.shulker.color." + output.m_41778_());
            return new ShapelessRecipe(id, group, output, inputs);
        });
    }

    private ShulkerBoxColoringRecipeMaker() {
    }
}

