/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.util.MathUtil;
import mezz.jei.util.StringUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class IngredientInfoRecipe<T> {
    private static final int lineSpacing = 2;
    private final List<FormattedText> description;
    private final List<T> ingredients;
    private final IIngredientType<T> ingredientType;

    public static <T> List<IngredientInfoRecipe<T>> create(List<T> ingredients, IIngredientType<T> ingredientType, Component ... descriptionComponents) {
        ArrayList<IngredientInfoRecipe<T>> recipes = new ArrayList<IngredientInfoRecipe<T>>();
        List<FormattedText> descriptionLines = StringUtil.expandNewlines(descriptionComponents);
        descriptionLines = StringUtil.splitLines(descriptionLines, 160);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.m_91087_();
        Objects.requireNonNull(minecraft.f_91062_);
        int maxLinesPerPage = 105 / (9 + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<FormattedText> description = descriptionLines.subList(startLine, endLine);
            IngredientInfoRecipe<T> recipe = new IngredientInfoRecipe<T>(ingredients, ingredientType, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private IngredientInfoRecipe(List<T> ingredients, IIngredientType<T> ingredientType, List<FormattedText> description) {
        this.description = description;
        this.ingredients = ingredients;
        this.ingredientType = ingredientType;
    }

    public List<FormattedText> getDescription() {
        return this.description;
    }

    public IIngredientType<T> getIngredientType() {
        return this.ingredientType;
    }

    public List<T> getIngredients() {
        return this.ingredients;
    }
}

