/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.ingredients.IngredientInformationUtil;

public class IngredientBlacklistInternal {
    private final Set<String> ingredientBlacklist = new HashSet<String>();

    public <V> void addIngredientToBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        String uniqueName = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
        this.ingredientBlacklist.add(uniqueName);
    }

    public <V> void removeIngredientFromBlacklist(V ingredient, IIngredientHelper<V> ingredientHelper) {
        String uniqueName = ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
        this.ingredientBlacklist.remove(uniqueName);
    }

    public <V> boolean isIngredientBlacklistedByApi(V ingredient, IIngredientHelper<V> ingredientHelper) {
        List<String> uids = IngredientInformationUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient, UidContext.Ingredient);
        return uids.stream().anyMatch(this.ingredientBlacklist::contains);
    }
}

