/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.IClientConfig;
import mezz.jei.config.IEditModeConfig;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.config.SearchMode;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiIngredientProperties;
import mezz.jei.gui.overlay.GridAlignment;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientInfo;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.MouseUtil;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.render.IngredientListBatchRenderer;
import mezz.jei.render.IngredientListElementRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.render.IngredientRenderHelper;
import mezz.jei.util.GiveMode;
import mezz.jei.util.MathUtil;
import mezz.jei.util.StringUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class IngredientGrid
implements IRecipeFocusSource {
    private static final int INGREDIENT_PADDING = 1;
    public static final int INGREDIENT_WIDTH = GuiIngredientProperties.getWidth(1);
    public static final int INGREDIENT_HEIGHT = GuiIngredientProperties.getHeight(1);
    private final IngredientManager ingredientManager;
    private final GridAlignment alignment;
    private final RecipesGui recipesGui;
    private final IModIdHelper modIdHelper;
    private final GuiScreenHelper guiScreenHelper;
    private Rect2i area = new Rect2i(0, 0, 0, 0);
    protected final IngredientListBatchRenderer guiIngredientSlots;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IClientConfig clientConfig;
    private final IWorldConfig worldConfig;

    public IngredientGrid(IngredientManager ingredientManager, GridAlignment alignment, IEditModeConfig editModeConfig, IIngredientFilterConfig ingredientFilterConfig, IClientConfig clientConfig, IWorldConfig worldConfig, GuiScreenHelper guiScreenHelper, RecipesGui recipesGui, IModIdHelper modIdHelper) {
        this.ingredientManager = ingredientManager;
        this.alignment = alignment;
        this.recipesGui = recipesGui;
        this.modIdHelper = modIdHelper;
        this.guiIngredientSlots = new IngredientListBatchRenderer(clientConfig, editModeConfig, worldConfig, ingredientManager);
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.clientConfig = clientConfig;
        this.worldConfig = worldConfig;
        this.guiScreenHelper = guiScreenHelper;
    }

    public int size() {
        return this.guiIngredientSlots.size();
    }

    public int maxWidth() {
        int columns = this.clientConfig.getMaxColumns();
        int ingredientsWidth = columns * INGREDIENT_WIDTH;
        int minWidth = this.clientConfig.getMinColumns() * INGREDIENT_WIDTH;
        return Math.max(ingredientsWidth, minWidth);
    }

    public boolean updateBounds(Rect2i availableArea, Collection<Rect2i> exclusionAreas) {
        int columns = Math.min(availableArea.m_110090_() / INGREDIENT_WIDTH, this.clientConfig.getMaxColumns());
        int rows = availableArea.m_110091_() / INGREDIENT_HEIGHT;
        int ingredientsWidth = columns * INGREDIENT_WIDTH;
        int minWidth = this.clientConfig.getMinColumns() * INGREDIENT_WIDTH;
        int width = Math.max(ingredientsWidth, minWidth);
        int height = rows * INGREDIENT_HEIGHT;
        int x = this.alignment == GridAlignment.LEFT ? availableArea.m_110085_() + (availableArea.m_110090_() - width) : availableArea.m_110085_();
        int y = availableArea.m_110086_() + (availableArea.m_110091_() - height) / 2;
        int xOffset = x + Math.max(0, (width - ingredientsWidth) / 2);
        this.area = new Rect2i(x, y, width, height);
        this.guiIngredientSlots.clear();
        if (rows == 0 || columns < this.clientConfig.getMinColumns()) {
            return false;
        }
        for (int row = 0; row < rows; ++row) {
            int y1 = y + row * INGREDIENT_HEIGHT;
            for (int column = 0; column < columns; ++column) {
                int x1 = xOffset + column * INGREDIENT_WIDTH;
                IngredientListSlot ingredientListSlot = new IngredientListSlot(x1, y1, 1);
                Rect2i stackArea = ingredientListSlot.getArea();
                boolean blocked = MathUtil.intersects(exclusionAreas, stackArea);
                ingredientListSlot.setBlocked(blocked);
                this.guiIngredientSlots.add(ingredientListSlot);
            }
        }
        return true;
    }

    public Rect2i getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        IngredientListElementRenderer<?> hovered;
        RenderSystem.m_69461_();
        this.guiIngredientSlots.render(minecraft, poseStack);
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY) && this.isMouseOver(mouseX, mouseY) && (hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY)) != null) {
            IngredientGrid.drawHighlight(poseStack, hovered.getArea());
        }
    }

    public static void drawHighlight(PoseStack poseStack, Rect2i area) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)area.m_110085_(), (int)area.m_110086_(), (int)(area.m_110085_() + area.m_110090_()), (int)(area.m_110086_() + area.m_110091_()), (int)-2130706433);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
                TranslatableComponent deleteItem = new TranslatableComponent("jei.tooltip.delete.item");
                TooltipRenderer.drawHoveringText(poseStack, List.of(deleteItem), mouseX, mouseY);
            } else {
                IngredientListElementRenderer<?> hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY);
                if (hovered != null) {
                    this.drawTooltip(poseStack, mouseX, mouseY, this.ingredientFilterConfig, this.worldConfig, hovered.getIngredient());
                }
            }
        }
    }

    private <T> void drawTooltip(PoseStack poseStack, int mouseX, int mouseY, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig, T ingredient) {
        IIngredientType<T> ingredientType = this.ingredientManager.getIngredientType(ingredient);
        IngredientInfo<T> ingredientInfo = this.ingredientManager.getIngredientInfo(ingredientType);
        IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();
        List<FormattedText> tooltip = this.getTooltip(ingredientFilterConfig, worldConfig, ingredient, ingredientInfo);
        TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY, ingredient, ingredientRenderer);
    }

    private <T> List<FormattedText> getTooltip(IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig, T ingredient, IngredientInfo<T> ingredientInfo) {
        IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();
        IIngredientHelper<T> ingredientHelper = ingredientInfo.getIngredientHelper();
        List<Component> ingredientTooltipSafe = IngredientRenderHelper.getIngredientTooltipSafe(ingredient, ingredientRenderer, ingredientHelper, this.modIdHelper);
        ArrayList<Component> tooltip = new ArrayList<Component>(ingredientTooltipSafe);
        Minecraft minecraft = Minecraft.m_91087_();
        int maxWidth = 150;
        for (FormattedText formattedText : tooltip) {
            int width = minecraft.f_91062_.m_92852_(formattedText);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            IngredientGrid.addColorSearchInfoToTooltip(tooltip, maxWidth, ingredient, ingredientInfo);
        }
        if (worldConfig.isEditModeEnabled()) {
            IngredientGrid.addEditModeInfoToTooltip(tooltip, maxWidth);
        }
        return tooltip;
    }

    public static <T> void addColorSearchInfoToTooltip(List<FormattedText> tooltip, int maxWidth, T ingredient, IngredientInfo<T> ingredientInfo) {
        IIngredientHelper<T> ingredientHelper;
        Iterable<Integer> colors;
        ColorNamer colorNamer = Internal.getColorNamer();
        Collection<String> colorNames = colorNamer.getColorNames(colors = (ingredientHelper = ingredientInfo.getIngredientHelper()).getColors(ingredient), false);
        if (!colorNames.isEmpty()) {
            String colorNamesString = Joiner.on((String)", ").join(colorNames);
            MutableComponent colorTranslation = new TranslatableComponent("jei.tooltip.item.colors", new Object[]{colorNamesString}).m_130940_(ChatFormatting.GRAY);
            List<FormattedText> lines = StringUtil.splitLines((FormattedText)colorTranslation, maxWidth);
            tooltip.addAll(lines);
        }
    }

    public static void addEditModeInfoToTooltip(List<FormattedText> tooltip, int maxWidth) {
        List<MutableComponent> lines = List.of(TextComponent.f_131282_, new TranslatableComponent("gui.jei.editMode.description").m_130940_(ChatFormatting.DARK_GREEN), new TranslatableComponent("gui.jei.editMode.description.hide", new Object[]{KeyBindings.toggleHideIngredient.m_90863_()}).m_130940_(ChatFormatting.GRAY), new TranslatableComponent("gui.jei.editMode.description.hide.wild", new Object[]{KeyBindings.toggleWildcardHideIngredient.m_90863_()}).m_130940_(ChatFormatting.GRAY));
        lines = StringUtil.splitLines(lines, maxWidth);
        tooltip.addAll(lines);
    }

    private boolean shouldDeleteItemOnClick(Minecraft minecraft, double mouseX, double mouseY) {
        Object obj;
        IClickedIngredient<?> ingredientUnderMouse;
        if (!this.worldConfig.isDeleteItemsInCheatModeActive()) {
            return false;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        ItemStack itemStack = player.f_36096_.m_142621_();
        if (itemStack.m_41619_()) {
            return false;
        }
        if (this.recipesGui.isOpen()) {
            return false;
        }
        GiveMode giveMode = this.clientConfig.getGiveMode();
        if (giveMode == GiveMode.MOUSE_PICKUP && (ingredientUnderMouse = this.getIngredientUnderMouse(mouseX, mouseY)) != null && (obj = ingredientUnderMouse.getValue()) instanceof ItemStack) {
            ItemStack value = (ItemStack)obj;
            return !ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)value);
        }
        return true;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    public <T> Optional<T> getIngredientUnderMouse(IIngredientType<T> ingredientType) {
        return this.guiIngredientSlots.getHovered(MouseUtil.getX(), MouseUtil.getY(), ingredientType).map(IngredientListElementRenderer::getIngredient);
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(double mouseX, double mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ClickedIngredient<?> clicked = this.guiIngredientSlots.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                clicked.setAllowsCheating();
                clicked.setCanSetFocusWithMouse();
            }
            return clicked;
        }
        return null;
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler();
    }

    private class UserInputHandler
    implements IUserInputHandler {
        private UserInputHandler() {
        }

        @Override
        @Nullable
        public IUserInputHandler handleUserInput(Screen screen, UserInput userInput) {
            double mouseY;
            double mouseX = userInput.getMouseX();
            if (!IngredientGrid.this.isMouseOver(mouseX, mouseY = userInput.getMouseY())) {
                return null;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (!IngredientGrid.this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
                return null;
            }
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return null;
            }
            ItemStack itemStack = player.f_36096_.m_142621_();
            if (itemStack.m_41619_()) {
                return null;
            }
            if (!userInput.isSimulate()) {
                player.f_36096_.m_142503_(ItemStack.f_41583_);
                PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                Network.sendPacketToServer(packet);
            }
            return this;
        }
    }
}

