/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.CycleTimer;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.render.IngredientRenderHelper;
import mezz.jei.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiIngredient<T>
extends GuiComponent
implements IGuiIngredient<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int slotIndex;
    private final boolean input;
    private final Rect2i rect;
    private final int xPadding;
    private final int yPadding;
    private final CycleTimer cycleTimer;
    private final List<T> displayIngredients = new ArrayList<T>();
    private final List<T> allIngredients = new ArrayList<T>();
    private final IIngredientRenderer<T> ingredientRenderer;
    private final IIngredientHelper<T> ingredientHelper;
    private List<ITooltipCallback<T>> tooltipCallbacks = Collections.emptyList();
    @Nullable
    private IDrawable background;
    private boolean enabled;

    public GuiIngredient(int slotIndex, boolean input, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper, Rect2i rect, int xPadding, int yPadding, int cycleOffset) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredientHelper = ingredientHelper;
        this.slotIndex = slotIndex;
        this.input = input;
        this.rect = rect;
        this.xPadding = xPadding;
        this.yPadding = yPadding;
        this.cycleTimer = new CycleTimer(cycleOffset);
    }

    @Override
    public IIngredientType<T> getIngredientType() {
        return this.ingredientHelper.getIngredientType();
    }

    public Rect2i getRect() {
        return this.rect;
    }

    public boolean isMouseOver(double xOffset, double yOffset, double mouseX, double mouseY) {
        return this.enabled && mouseX >= xOffset + (double)this.rect.m_110085_() && mouseY >= yOffset + (double)this.rect.m_110086_() && mouseX < xOffset + (double)this.rect.m_110085_() + (double)this.rect.m_110090_() && mouseY < yOffset + (double)this.rect.m_110086_() + (double)this.rect.m_110091_();
    }

    @Override
    @Nullable
    public T getDisplayedIngredient() {
        return this.cycleTimer.getCycledItem(this.displayIngredients);
    }

    @Override
    public List<T> getAllIngredients() {
        return this.allIngredients;
    }

    public void set(@Nullable List<T> ingredients, @Nullable Focus<T> focus) {
        this.displayIngredients.clear();
        this.allIngredients.clear();
        List displayIngredients = Objects.requireNonNullElse(ingredients, Collections.emptyList());
        Object match = this.getMatch(displayIngredients, focus);
        if (match != null) {
            this.displayIngredients.add(match);
        } else {
            displayIngredients = this.filterOutHidden(displayIngredients);
            this.displayIngredients.addAll(displayIngredients);
        }
        if (ingredients != null) {
            this.allIngredients.addAll(ingredients);
        }
        this.enabled = !this.displayIngredients.isEmpty();
    }

    private List<T> filterOutHidden(List<T> ingredients) {
        if (ingredients.isEmpty()) {
            return ingredients;
        }
        IngredientFilter ingredientFilter = Internal.getIngredientFilter();
        ArrayList<T> visible = new ArrayList<T>();
        for (T ingredient : ingredients) {
            if (ingredient == null || ingredientFilter.isIngredientVisible(ingredient)) {
                visible.add(ingredient);
            }
            if (visible.size() <= 100) continue;
            return visible;
        }
        if (visible.size() > 0) {
            return visible;
        }
        return ingredients;
    }

    public void setBackground(IDrawable background) {
        this.background = background;
    }

    @Nullable
    private T getMatch(Collection<T> ingredients, @Nullable Focus<T> focus) {
        if (focus != null && this.isMode(focus.getMode())) {
            T focusValue = focus.getValue();
            return this.ingredientHelper.getMatch(ingredients, focusValue, UidContext.Ingredient);
        }
        return null;
    }

    public void setTooltipCallbacks(List<ITooltipCallback<T>> tooltipCallbacks) {
        this.tooltipCallbacks = tooltipCallbacks;
    }

    public void draw(PoseStack poseStack, int xOffset, int yOffset) {
        this.cycleTimer.onDraw();
        if (this.background != null) {
            this.background.draw(poseStack, xOffset + this.rect.m_110085_(), yOffset + this.rect.m_110086_());
        }
        T value = this.getDisplayedIngredient();
        try {
            this.ingredientRenderer.render(poseStack, xOffset + this.rect.m_110085_() + this.xPadding, yOffset + this.rect.m_110086_() + this.yPadding, value);
        }
        catch (LinkageError | RuntimeException e) {
            if (value != null) {
                throw ErrorUtil.createRenderIngredientException(e, value);
            }
            throw e;
        }
    }

    @Override
    public void drawHighlight(PoseStack poseStack, int color, int xOffset, int yOffset) {
        int x = this.rect.m_110085_() + xOffset + this.xPadding;
        int y = this.rect.m_110086_() + yOffset + this.yPadding;
        RenderSystem.m_69465_();
        GuiIngredient.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + this.rect.m_110090_() - this.xPadding * 2), (int)(y + this.rect.m_110091_() - this.yPadding * 2), (int)color);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawOverlays(PoseStack poseStack, int xOffset, int yOffset, int mouseX, int mouseY) {
        T value = this.getDisplayedIngredient();
        if (value != null) {
            this.drawTooltip(poseStack, xOffset, yOffset, mouseX, mouseY, value);
        }
    }

    private void drawTooltip(PoseStack poseStack, int xOffset, int yOffset, int mouseX, int mouseY, T value) {
        try {
            List<ItemStack> itemStacks;
            ResourceLocation tagEquivalent;
            RenderSystem.m_69465_();
            GuiIngredient.m_93172_((PoseStack)poseStack, (int)(xOffset + this.rect.m_110085_() + this.xPadding), (int)(yOffset + this.rect.m_110086_() + this.yPadding), (int)(xOffset + this.rect.m_110085_() + this.rect.m_110090_() - this.xPadding), (int)(yOffset + this.rect.m_110086_() + this.rect.m_110091_() - this.yPadding), (int)Integer.MAX_VALUE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
            List<Component> tooltip = IngredientRenderHelper.getIngredientTooltipSafe(value, this.ingredientRenderer, this.ingredientHelper, modIdHelper);
            for (ITooltipCallback<T> tooltipCallback : this.tooltipCallbacks) {
                tooltipCallback.onTooltip(this.slotIndex, this.input, value, tooltip);
            }
            if (value instanceof ItemStack && (tagEquivalent = GuiIngredient.getTagEquivalent(itemStacks = this.allIngredients)) != null) {
                TranslatableComponent acceptsAny = new TranslatableComponent("jei.tooltip.recipe.tag", new Object[]{tagEquivalent});
                tooltip.add((Component)acceptsAny.m_130940_(ChatFormatting.GRAY));
            }
            TooltipRenderer.drawHoveringText(poseStack, tooltip, xOffset + mouseX, yOffset + mouseY, value, this.ingredientRenderer);
            RenderSystem.m_69482_();
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception when rendering tooltip on {}.", value, (Object)e);
        }
    }

    @Nullable
    private static ResourceLocation getTagEquivalent(Collection<ItemStack> itemStacks) {
        if (itemStacks.size() < 2) {
            return null;
        }
        List<Item> items = itemStacks.stream().filter(Objects::nonNull).map(ItemStack::m_41720_).toList();
        TagCollection collection = ItemTags.m_13193_();
        Collection tags = collection.m_5643_().values();
        return tags.stream().filter(tag -> tag.m_6497_().equals(items)).findFirst().map(arg_0 -> ((TagCollection)collection).m_7473_(arg_0)).orElse(null);
    }

    @Override
    public boolean isInput() {
        return this.input;
    }

    public boolean isMode(IFocus.Mode mode) {
        return this.input && mode == IFocus.Mode.INPUT || !this.input && mode == IFocus.Mode.OUTPUT;
    }
}

