/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.phys.Vec2;

public class GhostIngredientReturning<T> {
    private static final long DURATION_PER_SCREEN_WIDTH = 500L;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final T ingredient;
    private final Vec2 start;
    private final Vec2 end;
    private final long startTime;
    private final long duration;

    @Nullable
    public static <T> GhostIngredientReturning<T> create(GhostIngredientDrag<T> ghostIngredientDrag, double mouseX, double mouseY) {
        Rect2i origin = ghostIngredientDrag.getOrigin();
        if (origin != null) {
            IIngredientRenderer<T> ingredientRenderer = ghostIngredientDrag.getIngredientRenderer();
            T ingredient = ghostIngredientDrag.getIngredient();
            Vec2 end = new Vec2((float)origin.m_110085_(), (float)origin.m_110086_());
            Vec2 start = new Vec2((float)mouseX - 8.0f, (float)mouseY - 8.0f);
            return new GhostIngredientReturning<T>(ingredientRenderer, ingredient, start, end);
        }
        return null;
    }

    private GhostIngredientReturning(IIngredientRenderer<T> ingredientRenderer, T ingredient, Vec2 start, Vec2 end) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.start = start;
        this.end = end;
        this.startTime = System.currentTimeMillis();
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen != null) {
            int width = currentScreen.f_96543_;
            float durationPerPixel = 500.0f / (float)width;
            float distance = (float)MathUtil.distance(start, end);
            this.duration = Math.round(durationPerPixel * distance);
        } else {
            this.duration = Math.round(250.0f);
        }
    }

    public void drawItem(Minecraft minecraft, PoseStack poseStack) {
        long time = System.currentTimeMillis();
        long elapsed = time - this.startTime;
        double percent = Math.min((double)elapsed / (double)this.duration, 1.0);
        double dx = this.end.f_82470_ - this.start.f_82470_;
        double dy = this.end.f_82471_ - this.start.f_82471_;
        double x = this.start.f_82470_ + (float)Math.round(dx * percent);
        double y = this.start.f_82471_ + (float)Math.round(dy * percent);
        ItemRenderer itemRenderer = minecraft.m_91291_();
        itemRenderer.f_115093_ += 150.0f;
        this.ingredientRenderer.render(poseStack, (int)x, (int)y, this.ingredient);
        itemRenderer.f_115093_ -= 150.0f;
    }

    public boolean isComplete() {
        long time = System.currentTimeMillis();
        return this.startTime + this.duration < time;
    }
}

