/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.config.IWorldConfig;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import mezz.jei.gui.ghost.GhostIngredientReturning;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IRecipeFocusSource;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.item.ItemStack;

public class GhostIngredientDragManager {
    private final IRecipeFocusSource source;
    private final GuiScreenHelper guiScreenHelper;
    private final IngredientManager ingredientManager;
    private final IWorldConfig worldConfig;
    private final List<GhostIngredientReturning<?>> ghostIngredientsReturning = new ArrayList();
    @Nullable
    private GhostIngredientDrag<?> ghostIngredientDrag;
    @Nullable
    private Object hoveredIngredient;
    @Nullable
    private List<IGhostIngredientHandler.Target<Object>> hoveredIngredientTargets;

    public GhostIngredientDragManager(IRecipeFocusSource source, GuiScreenHelper guiScreenHelper, IngredientManager ingredientManager, IWorldConfig worldConfig) {
        this.source = source;
        this.guiScreenHelper = guiScreenHelper;
        this.ingredientManager = ingredientManager;
        this.worldConfig = worldConfig;
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (!(minecraft.f_91080_ instanceof AbstractContainerScreen)) {
            this.drawGhostIngredientHighlights(minecraft, poseStack, mouseX, mouseY);
        }
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawItem(minecraft, poseStack, mouseX, mouseY);
        }
        this.ghostIngredientsReturning.forEach(returning -> returning.drawItem(minecraft, poseStack));
        this.ghostIngredientsReturning.removeIf(GhostIngredientReturning::isComplete);
    }

    public void drawOnForeground(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        this.drawGhostIngredientHighlights(minecraft, poseStack, mouseX, mouseY);
    }

    private void drawGhostIngredientHighlights(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawTargets(poseStack, mouseX, mouseY);
        } else {
            Object hovered;
            IClickedIngredient<?> elementUnderMouse = this.source.getIngredientUnderMouse(mouseX, mouseY);
            Object i = hovered = elementUnderMouse == null ? null : (Object)elementUnderMouse.getValue();
            if (!Objects.equals(hovered, this.hoveredIngredient)) {
                IGhostIngredientHandler<Screen> handler;
                this.hoveredIngredient = hovered;
                this.hoveredIngredientTargets = null;
                Screen currentScreen = minecraft.f_91080_;
                if (currentScreen != null && hovered != null && (handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen)) != null && handler.shouldHighlightTargets()) {
                    this.hoveredIngredientTargets = handler.getTargets(currentScreen, hovered, false);
                }
            }
            if (this.hoveredIngredientTargets != null && !this.worldConfig.isCheatItemsEnabled()) {
                GhostIngredientDrag.drawTargets(poseStack, mouseX, mouseY, this.hoveredIngredientTargets);
            }
        }
    }

    public void stopDrag() {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.stop();
            this.ghostIngredientDrag = null;
        }
        this.hoveredIngredient = null;
        this.hoveredIngredientTargets = null;
    }

    private <T extends Screen, V> boolean handleClickGhostIngredient(T currentScreen, IClickedIngredient<V> clicked, UserInput input) {
        IGhostIngredientHandler<T> handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen);
        if (handler == null) {
            return false;
        }
        V ingredient = clicked.getValue();
        List targets = handler.getTargets(currentScreen, ingredient, true);
        if (targets.isEmpty()) {
            return false;
        }
        IIngredientRenderer<V> ingredientRenderer = this.ingredientManager.getIngredientRenderer(ingredient);
        Rect2i clickedArea = clicked.getArea();
        this.ghostIngredientDrag = new GhostIngredientDrag(handler, targets, ingredientRenderer, ingredient, input.getMouseX(), input.getMouseY(), clickedArea);
        return true;
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler();
    }

    private class UserInputHandler
    implements IUserInputHandler {
        private UserInputHandler() {
        }

        @Override
        @Nullable
        public IUserInputHandler handleDragStart(Screen screen, UserInput input) {
            if (screen instanceof RecipesGui) {
                return null;
            }
            IClickedIngredient<?> clicked = GhostIngredientDragManager.this.source.getIngredientUnderMouse(input.getMouseX(), input.getMouseY());
            if (clicked == null) {
                return null;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player == null) {
                return null;
            }
            ItemStack mouseItem = player.f_36096_.m_142621_();
            if (mouseItem.m_41619_() && GhostIngredientDragManager.this.handleClickGhostIngredient(screen, clicked, input)) {
                return this;
            }
            return null;
        }

        @Override
        @Nullable
        public IUserInputHandler handleDragComplete(Screen screen, UserInput input) {
            if (screen instanceof RecipesGui) {
                return null;
            }
            if (GhostIngredientDragManager.this.ghostIngredientDrag == null) {
                return null;
            }
            boolean success = GhostIngredientDragManager.this.ghostIngredientDrag.onClick(input);
            double mouseX = input.getMouseX();
            double mouseY = input.getMouseY();
            if (!success && GhostIngredientDrag.farEnoughToDraw(GhostIngredientDragManager.this.ghostIngredientDrag, mouseX, mouseY)) {
                GhostIngredientReturning<?> returning = GhostIngredientReturning.create(GhostIngredientDragManager.this.ghostIngredientDrag, mouseX, mouseY);
                GhostIngredientDragManager.this.ghostIngredientsReturning.add(returning);
            }
            GhostIngredientDragManager.this.ghostIngredientDrag = null;
            GhostIngredientDragManager.this.hoveredIngredientTargets = null;
            if (success) {
                return this;
            }
            return null;
        }

        @Override
        public void handleDragCanceled() {
            GhostIngredientDragManager.this.stopDrag();
        }
    }
}

